/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.mma.model;

import com.atlassian.migration.agent.dto.assessment.AppSummaryDto;
import com.atlassian.migration.agent.entity.AppAssessmentUserAttributedStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;

public class AppMetadata {
    private static final String CONFLUENCE_SERVER_PRODUCT_KEY = "confluence-server";
    @JsonProperty
    private final String serverId;
    @JsonProperty
    private final String cloudId;
    @JsonProperty
    private final String productKey;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String appKey;
    @JsonProperty
    private final Boolean assessedForCloud;

    public AppMetadata(AppSummaryDto appSummary, String cloudId, String serverId) {
        this.serverId = serverId;
        this.cloudId = cloudId;
        this.productKey = CONFLUENCE_SERVER_PRODUCT_KEY;
        this.name = appSummary.getName();
        this.appKey = appSummary.getKey();
        this.assessedForCloud = appSummary.getMigrationStatus() == AppAssessmentUserAttributedStatus.Needed;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public String getCloudId() {
        return this.cloudId;
    }

    @Generated
    public String getProductKey() {
        return this.productKey;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAppKey() {
        return this.appKey;
    }

    @Generated
    public Boolean getAssessedForCloud() {
        return this.assessedForCloud;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppMetadata)) {
            return false;
        }
        AppMetadata other = (AppMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$assessedForCloud = this.getAssessedForCloud();
        Boolean other$assessedForCloud = other.getAssessedForCloud();
        if (this$assessedForCloud == null ? other$assessedForCloud != null : !((Object)this$assessedForCloud).equals(other$assessedForCloud)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        String this$cloudId = this.getCloudId();
        String other$cloudId = other.getCloudId();
        if (this$cloudId == null ? other$cloudId != null : !this$cloudId.equals(other$cloudId)) {
            return false;
        }
        String this$productKey = this.getProductKey();
        String other$productKey = other.getProductKey();
        if (this$productKey == null ? other$productKey != null : !this$productKey.equals(other$productKey)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$appKey = this.getAppKey();
        String other$appKey = other.getAppKey();
        return !(this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $assessedForCloud = this.getAssessedForCloud();
        result = result * 59 + ($assessedForCloud == null ? 43 : ((Object)$assessedForCloud).hashCode());
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        String $cloudId = this.getCloudId();
        result = result * 59 + ($cloudId == null ? 43 : $cloudId.hashCode());
        String $productKey = this.getProductKey();
        result = result * 59 + ($productKey == null ? 43 : $productKey.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $appKey = this.getAppKey();
        result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AppMetadata(serverId=" + this.getServerId() + ", cloudId=" + this.getCloudId() + ", productKey=" + this.getProductKey() + ", name=" + this.getName() + ", appKey=" + this.getAppKey() + ", assessedForCloud=" + this.getAssessedForCloud() + ")";
    }
}

