/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4LogContext;
import com.atlassian.migration.agent.service.check.V4Logger;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.attachment.AttachmentMigrationExecutor;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.AttachmentUploadTransferTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class AttachmentUploadProcessor
extends AbstractProcessor<AttachmentUploadTransferTask> {
    private final AttachmentMigrationExecutor attachmentMigrationExecutor;
    private final Step prcStep;
    private final V4Logger v4Logger;
    private final ClusterInformationService clusterInformationService;
    private static final Logger log = ContextLoggerFactory.getLogger(AttachmentUploadProcessor.class);

    public AttachmentUploadProcessor(PrcTask<AttachmentUploadTransferTask> prcTask, Step prcStep, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, AttachmentMigrationExecutor attachmentMigrationExecutor, MigrationLogService migrationLogService, V4Logger v4Logger, ClusterInformationService clusterInformationService) {
        super(prcTask, prcPoller, pollerConfigHandler, migrationLogService);
        this.attachmentMigrationExecutor = attachmentMigrationExecutor;
        this.prcStep = prcStep;
        this.v4Logger = v4Logger;
        this.clusterInformationService = clusterInformationService;
    }

    @Override
    protected Pair<Step, StepResult> process() {
        V4LogContext logContext = V4LogContext.builder().stepId(this.prcStep.getId()).nodeId(this.clusterInformationService.getCurrentNodeId()).stepType(StepType.ATTACHMENT_UPLOAD.name()).nodeExecutionId(this.prcStep.getNodeExecutionId()).executionState(this.prcStep.getExecutionState()).build();
        this.v4Logger.logInfo(log, logContext, "Processing V4 attachment upload");
        this.setProgressStartTime(this.prcStep, StepType.ATTACHMENT_UPLOAD);
        StepResult result = this.attachmentMigrationExecutor.runStepV4(this.prcStep, this.prcTask);
        return Pair.of((Object)this.prcStep, (Object)result);
    }
}

