/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.store.guardrails.GuardrailsUtil;
import com.atlassian.migration.agent.store.guardrails.results.ListResult;
import com.atlassian.migration.agent.store.guardrails.results.TupleResult;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.persistence.Tuple;

public class ExampleDataBuilder {
    private final List<String> columns;
    private final List<List<Object>> elements = new ArrayList<List<Object>>();

    private ExampleDataBuilder(String ... columns) {
        this.columns = ImmutableList.copyOf((Object[])columns);
    }

    static ExampleDataBuilder columns(String ... columns) {
        return new ExampleDataBuilder(columns);
    }

    public ExampleDataBuilder addRow(Object ... data) {
        this.elements.add((List<Object>)ImmutableList.copyOf((Object[])data));
        return this;
    }

    public <T> T build(Function<List<Tuple>, T> constructor) {
        return constructor.apply(this.build());
    }

    public List<Tuple> build() {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (List<Object> element : this.elements) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (int i = 0; i < this.columns.size(); ++i) {
                map.put(this.columns.get(i), element.get(i));
            }
            tuples.add(GuardrailsUtil.getTuple(map));
        }
        return tuples;
    }

    public ListResult toListResult() {
        return new ListResult(this.build());
    }

    public TupleResult tupleResult(Object ... data) {
        return new TupleResult(this.addRow(data).build().get(0));
    }
}

