/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.MigrationSpaceStatus;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.store.MigrationSpaceStatusStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationSpaceStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationSpaceStatusService.class);
    private final PluginTransactionTemplate ptx;
    private final MigrationSpaceStatusStore migrationSpaceStatusStore;
    private final ExecutorService executor;
    private MigrationAgentConfiguration migrationAgentConfiguration;
    private EventPublisher eventPublisher;

    public MigrationSpaceStatusService(PluginTransactionTemplate ptx, MigrationSpaceStatusStore migrationSpaceStatusStore, MigrationAgentConfiguration migrationAgentConfiguration, EventPublisher eventPublisher) {
        this(ptx, migrationSpaceStatusStore, migrationAgentConfiguration, eventPublisher, Executors.newSingleThreadExecutor(new GroupedThreadFactory("MigrationSpaceStatusService")));
    }

    public MigrationSpaceStatusService(PluginTransactionTemplate ptx, MigrationSpaceStatusStore migrationSpaceStatusStore, MigrationAgentConfiguration migrationAgentConfiguration, EventPublisher eventPublisher, ExecutorService executor) {
        this.ptx = ptx;
        this.migrationSpaceStatusStore = migrationSpaceStatusStore;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.eventPublisher = eventPublisher;
        this.executor = executor;
    }

    @PostConstruct
    public void initialize() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void cleanUp() {
        this.executor.shutdown();
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            if (event.getPlugin().getKey().equals(this.migrationAgentConfiguration.getPluginKey())) {
                log.info("CCMA Plugin enabled, populating migration space status");
                if (this.getCount() == 0L) {
                    this.executor.execute(this::populateMigrationSpaceStatuses);
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to calculate server statistics after plugin is enabled due to :", (Throwable)e);
        }
    }

    public void saveOrUpdate(MigrationSpaceStatus migrationSpaceStatus) {
        try {
            this.ptx.write(() -> this.migrationSpaceStatusStore.saveOrUpdate(migrationSpaceStatus));
        }
        catch (Exception e) {
            log.error("Failed to save or update migration space status due to :", (Throwable)e);
        }
    }

    public long getCount() {
        return this.ptx.read(this.migrationSpaceStatusStore::count);
    }

    void populateMigrationSpaceStatuses() {
        try {
            List migrationSpaceStatuses = this.ptx.read(this.migrationSpaceStatusStore::getInitialMigrationSpaceStatuses);
            log.info("Populating initial migration space statuses with size: {}", (Object)migrationSpaceStatuses.size());
            this.ptx.write(() -> {
                for (MigrationSpaceStatus migrationSpaceStatus : migrationSpaceStatuses) {
                    try {
                        this.migrationSpaceStatusStore.saveOrUpdate(migrationSpaceStatus);
                    }
                    catch (Exception e) {
                        log.error("Failed to populate initial migration space status for space: {} and cloudId : {} due to error ", new Object[]{migrationSpaceStatus.getSpaceKey(), migrationSpaceStatus.getCloudId(), e});
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to populate initial migration space statuses due to error ", (Throwable)e);
        }
    }
}

