/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.service.impl.ConcurrencyHelper;
import com.atlassian.migration.agent.service.impl.ConcurrencySettingsCalculator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class ConcurrencySettingsServiceAutomatic {
    private final ConcurrencySettingsCalculator calculator;

    public ConcurrencySettingsServiceAutomatic(ConcurrencyHelper helper, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.calculator = new ConcurrencySettingsCalculator(helper, migrationDarkFeaturesManager);
    }

    public Map<ConcurrencySettingsEnum, Integer> getSettings() {
        return this.calculator.redistributePercentages();
    }

    public int getSpaceUsersMigrationExecutorConcurrencyClusterMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_MAX);
    }

    public int getSpaceUsersMigrationConcurrencyNodeMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_NODE_MAX);
    }

    public int getAttachmentMigrationConcurrencyClusterMax(@Nullable Plan plan) {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_CLUSTER_MAX, plan);
    }

    public int getAttachmentMigrationConcurrencyNodeMax(Plan plan) {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_NODE_MAX, plan);
    }

    public Integer getExportConcurrencyNodeMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_NODE_MAX);
    }

    public Integer getExportConcurrencyClusterMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_CLUSTER_MAX);
    }

    public Integer getUploadConcurrencyClusterMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_CLUSTER_MAX);
    }

    public int getUploadConcurrencyNodeMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_NODE_MAX);
    }

    public int getImportConcurrencyClusterMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_CLUSTER_MAX);
    }

    public int getImportConcurrencyNodeMax() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_NODE_MAX);
    }

    public int getAttachmentUploadConcurrency() {
        return this.getUpdatedStoredValue(ConcurrencySettingsEnum.ATTACHMENT_UPLOAD_CONCURRENCY);
    }

    private int getUpdatedStoredValue(ConcurrencySettingsEnum property) {
        return this.calculator.calculateSetting(property, Optional.empty());
    }

    private int getUpdatedStoredValue(ConcurrencySettingsEnum property, @Nullable Plan plan) {
        return this.calculator.calculateSetting(property, Optional.ofNullable(plan));
    }
}

