/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.ConcurrencyHelper;
import com.atlassian.migration.agent.service.impl.ConcurrencyLimitItem;
import com.atlassian.migration.agent.service.impl.ConcurrencyLimits;
import com.atlassian.migration.agent.service.impl.ConcurrencyV2Limits;
import com.atlassian.migration.agent.service.impl.ConcurrencyV4Limits;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

public class ConcurrencySettingsCalculator {
    private static final Logger LOGGER = ContextLoggerFactory.getLogger(ConcurrencySettingsCalculator.class);
    private final ConcurrencyHelper helper;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    public ConcurrencySettingsCalculator(ConcurrencyHelper helper, MigrationDarkFeaturesManager migrationDarkFeaturesManager) {
        this.helper = helper;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    public int calculateSetting(ConcurrencySettingsEnum property, Optional<Plan> plan) {
        if (plan.isPresent() && this.isAttachmentOnlyMigration(plan.get())) {
            return this.calculateAttachmentOnlySettings(property, this.isV4MigrationProtocolEnabled());
        }
        return this.redistributePercentages().getOrDefault((Object)property, property.getDefaultConcurrency());
    }

    private boolean isAttachmentOnlyMigration(Plan plan) {
        return this.getValue(plan.isAttachmentOnlyMigration());
    }

    private boolean getValue(Optional<Boolean> value) {
        return value.isPresent() && value.get() != false;
    }

    public Map<ConcurrencySettingsEnum, Integer> redistributePercentages() {
        return this.calculateWeightParameters(this.helper.getAmountOfNodes(), this.helper.getAvailableProcessors());
    }

    public Map<ConcurrencySettingsEnum, Integer> calculateWeightParameters(int nodes, int cpu) {
        boolean v4MigrationProtocolEnabled = this.isV4MigrationProtocolEnabled();
        ConcurrencyLimits limits = this.getLimits(nodes, v4MigrationProtocolEnabled);
        EnumMap<ConcurrencySettingsEnum, Integer> result = new EnumMap<ConcurrencySettingsEnum, Integer>(ConcurrencySettingsEnum.class);
        if (this.isSkipAttachmentUploadEnabled()) {
            result.put(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_NODE_MAX, 5);
            result.put(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_CLUSTER_MAX, 1);
            result.put(ConcurrencySettingsEnum.ATTACHMENT_UPLOAD_CONCURRENCY, 5);
        } else {
            result.put(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_NODE_MAX, this.helper.getValueWithinLimits((double)cpu / 2.0 * 1.25, limits.getAttachmentNodeMaxLimit()));
            result.put(ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_CLUSTER_MAX, this.helper.getValueWithinLimits((double)(cpu * nodes) / 2.0 * 1.25, limits.getAttachmentClusterMaxLimit()));
            result.put(ConcurrencySettingsEnum.ATTACHMENT_UPLOAD_CONCURRENCY, 20);
        }
        result.put(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_NODE_MAX, this.helper.getValueWithinLimits(cpu / 2, limits.getImportNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.IMPORT_CONCURRENCY_CLUSTER_MAX, this.helper.getValueWithinLimits(cpu * nodes / 2, limits.getImportClusterMaxLimit()));
        result.put(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_NODE_MAX, this.helper.getValueWithinLimits(cpu / 2, limits.getExportNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.EXPORT_CONCURRENCY_CLUSTER_MAX, this.helper.getValueWithinLimits(cpu * nodes / 2, limits.getExportClusterMaxLimit()));
        result.put(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_NODE_MAX, this.helper.getValueWithinLimits(cpu / 4, limits.getUploadNodeMaxLimit()));
        Double uploadClusterValue = v4MigrationProtocolEnabled ? (double)(cpu * nodes) / 5.5 : (double)cpu / 4.0;
        result.put(ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_CLUSTER_MAX, this.helper.getValueWithinLimits(((Number)uploadClusterValue).intValue(), limits.getUploadClusterMaxLimit()));
        result.put(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_NODE_MAX, this.helper.getValueWithinLimits(cpu / 4, limits.getSpaceUsersNodeMaxLimit()));
        result.put(ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_MAX, this.helper.getValueWithinLimits(cpu * nodes / 4, limits.getSpaceUsersMaxLimit()));
        return result;
    }

    private ConcurrencyLimits getLimits(int amountOfNodes, boolean v4MigrationProtocolEnabled) {
        return v4MigrationProtocolEnabled ? new ConcurrencyV4Limits(amountOfNodes) : new ConcurrencyV2Limits();
    }

    private int calculateLimits(String propertyName, int value, ConcurrencyLimitItem limit) {
        int result = Math.min(Math.max(value, limit.getMinimumLimit()), limit.getMaximumLimit());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[ThreadsAutoDistribution] '{}': '{}' of '{}' available. (Minimum Limit: '{}' - Maximum Limit: '{}')", new Object[]{propertyName, result, this.helper.getAvailableProcessors() * this.helper.getAmountOfNodes(), limit.getMinimumLimit(), limit.getMaximumLimit()});
        }
        return result;
    }

    protected boolean isV4MigrationProtocolEnabled() {
        try {
            return this.migrationDarkFeaturesManager.isV4MigrationProtocolEnabled();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    protected boolean isSkipAttachmentUploadEnabled() {
        try {
            return this.migrationDarkFeaturesManager.skipAttachmentUploadEnabled();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private int calculateAttachmentOnlySettings(ConcurrencySettingsEnum property, boolean v4MigrationProtocolEnabled) {
        int value;
        int amountOfNodes = this.helper.getAmountOfNodes();
        ConcurrencyLimits limits = this.getLimits(amountOfNodes, v4MigrationProtocolEnabled);
        switch (property) {
            case ATTACHMENT_CONCURRENCY_CLUSTER_MAX: {
                value = this.calculateLimits(property.name(), amountOfNodes, limits.getAttachmentClusterMaxLimit());
                break;
            }
            case ATTACHMENT_CONCURRENCY_NODE_MAX: {
                value = this.calculateLimits(property.name(), amountOfNodes, limits.getAttachmentNodeMaxLimit());
                break;
            }
            default: {
                value = 1;
                LOGGER.warn("[ThreadsAutoDistribution] value {} was not predicted as input of 'ConcurrencySettingsCalculator.calculateAttachmentSetting()'. Value will be set at minimum of 1", (Object)property);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[ThreadsAutoDistribution|calculateAttachmentSetting()] - 'Attachment Only' migration - '{}': '{}' (version: {})", new Object[]{property.name(), value, v4MigrationProtocolEnabled ? "V4" : "V2"});
        }
        return value;
    }
}

