/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.migration.agent.dto.ConcurrencySettingsEnum;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.ConcurrencyLimitItem;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;

public class ConcurrencyHelper {
    private static final Logger LOGGER = ContextLoggerFactory.getLogger(ConcurrencyHelper.class);
    private static final long ONE_MILLIS_IN_NANOS = 1000000L;
    private static final long ONE_SECOND_IN_NANOS = 1000000000L;
    private static final int MIN_AMOUNT_OF_CPU = 16;
    private static final int MIN_AMOUNT_OF_NODES = 2;
    private static final int NON_CLUSTERED = 1;
    private final ClusterManager clusterManager;

    public ConcurrencyHelper(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public static Map<ConcurrencySettingsEnum, Integer> getDefaultDistribution() {
        EnumMap<ConcurrencySettingsEnum, Integer> map = new EnumMap<ConcurrencySettingsEnum, Integer>(ConcurrencySettingsEnum.class);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_CLUSTER_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.ATTACHMENT_CONCURRENCY_NODE_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.EXPORT_CONCURRENCY_NODE_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.EXPORT_CONCURRENCY_CLUSTER_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.SPACE_USERS_CONCURRENCY_NODE_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_CLUSTER_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.UPLOAD_CONCURRENCY_NODE_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.IMPORT_CONCURRENCY_CLUSTER_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.IMPORT_CONCURRENCY_NODE_MAX);
        ConcurrencyHelper.decorateMap(map, ConcurrencySettingsEnum.ATTACHMENT_UPLOAD_CONCURRENCY);
        return map;
    }

    public int getAvailableProcessors() {
        long startTime = this.getStartTime();
        int result = Runtime.getRuntime().availableProcessors();
        this.logDebug("Available CPU Cores", result, startTime);
        return result;
    }

    public int getAmountOfNodes() {
        int result;
        long startTime = this.getStartTime();
        if (this.clusterManager.isClustered()) {
            result = this.clusterManager.getAllNodesInformation().size();
            this.logDebug("Number of nodes (Clustered)", result, startTime);
        } else {
            result = 1;
            this.logDebug("Number of nodes (NOT Clustered)", result, startTime);
        }
        return result;
    }

    public boolean isMatchingClusterRequirements() {
        long startTime = this.getStartTime();
        int availableProcessors = this.getAvailableProcessors();
        int amountOfNodes = this.getAmountOfNodes();
        boolean matchingClusterRequirements = availableProcessors >= 16 && amountOfNodes >= 2;
        this.logMatchingStatus(startTime, matchingClusterRequirements, amountOfNodes, availableProcessors);
        return matchingClusterRequirements;
    }

    public int getValueWithinLimits(Number value, ConcurrencyLimitItem limits) {
        return Math.min(limits.getMaximumLimit(), Math.max(value.intValue(), limits.getMinimumLimit()));
    }

    private static void decorateMap(Map<ConcurrencySettingsEnum, Integer> map, ConcurrencySettingsEnum setting) {
        map.put(setting, setting.getDefaultConcurrency());
    }

    private void logMatchingStatus(long startTime, boolean matchingClusterRequirements, int nodes, int cpu) {
        this.logDebug("[ThreadsAutoDistribution] Total Amount of Threads", nodes * cpu, startTime);
        if (!matchingClusterRequirements) {
            if (this.isWarnEnabled()) {
                LOGGER.warn("[ThreadsAutoDistribution] Environment does NOT support threads auto distribution: {} nodes with {} cpu each is BELOW the minimum threshold of {} nodes with {} cpu each", new Object[]{nodes, cpu, 2, 16});
            }
        } else if (this.isInfoEnabled()) {
            LOGGER.info("[ThreadsAutoDistribution] Environment DOES support threads auto distribution: {} nodes with {} cpu each MATCHES the minimum threshold of {} nodes with {} cpu each", new Object[]{nodes, cpu, 2, 16});
        }
    }

    private void logDebug(String label, int value, long startTimeInMillis) {
        if (this.isDebugEnabled()) {
            LOGGER.debug("[ThreadsAutoDistribution] {}}: {} (data gathered in {})", new Object[]{label, value, this.getElapsedTime(startTimeInMillis)});
        }
    }

    private String getElapsedTime(long startTime) {
        long time = System.nanoTime() - startTime;
        if (time > 1000000000L) {
            return time / 1000000000L + " seconds";
        }
        if (time > 1000000L) {
            return time / 1000000L + " milliseconds";
        }
        return time + " nanoseconds";
    }

    private long getStartTime() {
        return this.isDebugEnabled() ? System.nanoTime() : 0L;
    }

    protected boolean isDebugEnabled() {
        return LOGGER.isDebugEnabled();
    }

    protected boolean isInfoEnabled() {
        return LOGGER.isInfoEnabled();
    }

    protected boolean isWarnEnabled() {
        return LOGGER.isWarnEnabled();
    }
}

