/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.dto.CloudType;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.DefaultTypeSettings;
import com.atlassian.migration.agent.service.impl.MigrationSettingsType;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.PostConstruct;

public class CloudTypeSettingsService
extends DefaultTypeSettings {
    private static final TypeReference<Map<CloudType, Boolean>> MAP_TYPE_REFERENCE = new TypeReference<Map<CloudType, Boolean>>(){};

    public CloudTypeSettingsService(PluginSettingsFactory pluginSettingsFactory) {
        super(pluginSettingsFactory, MigrationSettingsType.CLOUD_TYPE);
    }

    @Override
    @PostConstruct
    public void initialize() {
        super.initialize();
    }

    public Map<CloudType, Boolean> getCloudTypeSettings() {
        return (Map)this.getSettings();
    }

    public boolean isCloudTypeEnabled(CloudType cloudType) {
        return this.getCloudTypeSettings().get((Object)cloudType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isValidSettings(Object settingsObj) {
        Map cloudTypeMap = (Map)settingsObj;
        if (cloudTypeMap == null) return false;
        if (cloudTypeMap.isEmpty()) return false;
        if (!Arrays.stream(CloudType.values()).allMatch(cloudTypeMap::containsKey)) return false;
        if (cloudTypeMap.values().stream().allMatch(value -> value == false)) return false;
        if (cloudTypeMap.values().stream().filter(Boolean::booleanValue).limit(2L).count() != 1L) return false;
        return true;
    }

    public boolean setCloudTypeSettings(Map<CloudType, Boolean> cloudTypeMap) {
        return this.putSettings(cloudTypeMap);
    }

    @Override
    public Object mapStringToObject(String cloudTypeMap) {
        return Jsons.readValue(cloudTypeMap, MAP_TYPE_REFERENCE);
    }

    @Override
    protected Object getDefaultPluginSettings() {
        return ImmutableMap.of((Object)((Object)CloudType.FEDRAMP), (Object)false, (Object)((Object)CloudType.STANDARD), (Object)true);
    }
}

