/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.guardrails.remote.CloudJobType;
import com.atlassian.plugins.cloud.connect.companion.client.CloudContext;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestMethod;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestService;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceLocator;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class CloudAssessmentCommunicationService {
    private static final Logger log = LoggerFactory.getLogger(CloudAssessmentCommunicationService.class);
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final CloudRequestServiceLocator cloudRequestServiceLocator;
    private final ObjectMapper objectMapper;

    public void failInCloud(CloudJobType jobType) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        log.info("Sending Assessment failed status for job type: {}", (Object)jobType);
        CloudResponse<String> cloudResponse = this.sendFinishAssessmentRequest(jobType, null);
        this.validateResponse(cloudResponse, HttpStatus.OK.value());
    }

    public CloudResponse<String> sendFinishAssessmentRequest(CloudJobType cloudJobType, @Nullable File zipFile) throws MalformedURLException, CloudRequestServiceNotAvailableException {
        URL url = UriBuilder.fromUri((String)this.migrationAgentConfiguration.getPortfolioAnalyzerServiceUrl()).path("l1-assessments").queryParam("jobType", new Object[]{cloudJobType.name()}).build(new Object[0]).toURL();
        CloudRequestService cloudRequestService = this.cloudRequestServiceLocator.getCloudRequestService();
        CloudRequest.HeaderCollector request = CloudRequest.builder((Object)zipFile).method(CloudRequestMethod.PUT).url(url).cloudContext(CloudContext.defaultContext());
        if (zipFile != null) {
            request.header("Content-Type", "multipart/form-data");
            log.info("Sending finish assessment request with file of size: {}. For cloudJobType: {}", (Object)zipFile.length(), (Object)cloudJobType);
        } else {
            log.info("Sending finish assessment request with empty body. For cloudJobType: {}", (Object)cloudJobType);
        }
        return cloudRequestService.sendRequest(request.build(), String.class, new CloudObjectMapper(){

            public <T> T readValue(byte[] bytes, Class<T> aClass) throws IOException {
                return (T)CloudAssessmentCommunicationService.this.objectMapper.readValue(bytes, aClass);
            }

            public byte[] writeValueAsBytes(Object o) throws IOException {
                return CloudAssessmentCommunicationService.this.objectMapper.writeValueAsBytes(o);
            }
        });
    }

    public boolean isConnected() {
        try {
            return this.cloudRequestServiceLocator.getCloudLink().isPresent();
        }
        catch (CloudRequestServiceNotAvailableException | IncompatibleServiceException e) {
            return false;
        }
    }

    private void validateResponse(CloudResponse<String> cloudResponse, int expectedStatus) {
        if (cloudResponse.getStatusCode() != expectedStatus) {
            throw new WebApplicationException(Response.status((int)cloudResponse.getStatusCode()).entity(cloudResponse.getBody()).build());
        }
    }

    @Generated
    public CloudAssessmentCommunicationService(MigrationAgentConfiguration migrationAgentConfiguration, CloudRequestServiceLocator cloudRequestServiceLocator, ObjectMapper objectMapper) {
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.cloudRequestServiceLocator = cloudRequestServiceLocator;
        this.objectMapper = objectMapper;
    }
}

