/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.macro;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessment;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentWithNesting;
import com.atlassian.migration.agent.service.guardrails.macro.MacroInformationSupplier;
import com.atlassian.migration.agent.service.guardrails.macro.MacroResultSetConverter;
import com.atlassian.migration.agent.service.guardrails.macro.MacroStatus;
import com.atlassian.migration.agent.service.guardrails.macro.MacroTuple;
import com.atlassian.migration.agent.service.guardrails.macro.MacrosAssessmentPerSpace;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Tuple;
import lombok.Generated;

class DefaultMacroResultSetConverter
implements MacroResultSetConverter {
    public static final String BASE_PATH = "%s";
    public static final String PAGE_PATH = "%s/pages/viewpage.action?pageId=%d";
    public static final String COMMENT_PATH = "%s/pages/viewpage.action?pageId=%d&focusedCommentId=%d#comment-%d";
    private final MacroInformationSupplier macroInformationSupplier;
    private final SystemInformationService sysInfoService;
    private final EntityManagerTemplate entityManagerTemplate;

    @Override
    public MacroAssessmentResult convert(Set<MacroTuple> macroTuple) {
        Map<Long, Set<MacroTuple>> groupedBySpace = this.groupBySpace(macroTuple);
        Set<MacrosAssessmentPerSpace> macrosAssessmentPerSpaces = this.getMacrosAssessmentPerSpace(groupedBySpace);
        return new MacroAssessmentResult(macrosAssessmentPerSpaces, this.getUniqueContentCount(macroTuple), this.getUniqueMacroCount(macroTuple));
    }

    private Set<MacrosAssessmentPerSpace> getMacrosAssessmentPerSpace(Map<Long, Set<MacroTuple>> groupedBySpace) {
        String baseUrl = this.sysInfoService.getConfluenceInfo().getBaseUrl();
        HashSet<MacrosAssessmentPerSpace> macrosAssessmentPerSpace = new HashSet<MacrosAssessmentPerSpace>();
        Map<Long, Long> spacesHomePageId = this.getSpacesHomePageId(groupedBySpace.keySet());
        for (Map.Entry<Long, Set<MacroTuple>> entry : groupedBySpace.entrySet()) {
            Optional<MacrosAssessmentPerSpace> macrosAssessmentForSpace = this.getMacrosAssessmentForSpace(entry.getKey(), spacesHomePageId.get(entry.getKey()), entry.getValue(), baseUrl);
            macrosAssessmentForSpace.ifPresent(macrosAssessmentPerSpace::add);
        }
        return macrosAssessmentPerSpace;
    }

    private Map<Long, Long> getSpacesHomePageId(Set<Long> spaceIds) {
        return this.entityManagerTemplate.nativeQuery(Tuple.class, "select SPACEID, HOMEPAGE from SPACES where HOMEPAGE is not null and SPACEID in (:spaceIds)").batchedParam("spaceIds", spaceIds).stream().collect(Collectors.toMap(e -> ((Number)e.get(0, Number.class)).longValue(), e -> ((Number)e.get(1, Number.class)).longValue()));
    }

    private Optional<MacrosAssessmentPerSpace> getMacrosAssessmentForSpace(long spaceId, Long spaceHomePageId, Set<MacroTuple> macros, String baseUrl) {
        Map byStatus = macros.stream().collect(Collectors.groupingBy(this::getMacroStatus, Collectors.toSet()));
        Set<MacroAssessment> unavailable = this.toMacroAssessment(byStatus.getOrDefault((Object)MacroStatus.NOT_AVAILABLE, Collections.emptySet()), baseUrl);
        Set<MacroAssessment> different = this.toMacroAssessment(byStatus.getOrDefault((Object)MacroStatus.DIFFERENT, Collections.emptySet()), baseUrl);
        Set<MacroAssessmentWithNesting> nested = this.toMacroAssessmentWithNesting(byStatus.getOrDefault((Object)MacroStatus.NESTED, Collections.emptySet()), baseUrl);
        return unavailable.isEmpty() && different.isEmpty() && nested.isEmpty() ? Optional.empty() : Optional.of(new MacrosAssessmentPerSpace(spaceId, DefaultMacroResultSetConverter.viewPageUrl(baseUrl, spaceHomePageId), unavailable, different, nested));
    }

    private Set<MacroAssessment> toMacroAssessment(Set<MacroTuple> results, String baseUrl) {
        return this.convert(results, (name, macros) -> new MacroAssessment((String)name, this.convertContentUrls((Set<MacroTuple>)macros, baseUrl)));
    }

    private Set<MacroAssessmentWithNesting> toMacroAssessmentWithNesting(Set<MacroTuple> results, String baseUrl) {
        return this.convert(results, (name, macros) -> new MacroAssessmentWithNesting((String)name, this.convertContentUrls((Set<MacroTuple>)macros, baseUrl), this.convertChildren((Collection<MacroTuple>)macros)));
    }

    private <T> Set<T> convert(Set<MacroTuple> results, BiFunction<String, Set<MacroTuple>, T> producer) {
        Map macroOccurrences = results.stream().collect(Collectors.groupingBy(MacroTuple::getMacro, Collectors.mapping(Function.identity(), Collectors.toSet())));
        return macroOccurrences.entrySet().stream().map(entry -> producer.apply((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toSet());
    }

    private List<MacroAssessmentWithNesting.NestedMacro> convertChildren(Collection<MacroTuple> macros) {
        return macros.stream().flatMap(macro -> this.convertNestedChildren(macro.getNestedMacro()).stream()).collect(Collectors.toList());
    }

    private List<MacroAssessmentWithNesting.NestedMacro> convertNestedChildren(List<MacroTuple.NestedMacroTuple> nestedMacro) {
        return nestedMacro.stream().map(nm -> new MacroAssessmentWithNesting.NestedMacro(nm.getMacro(), nm.getLevel(), this.convertNestedChildren(nm.getChildren()))).collect(Collectors.toList());
    }

    private Set<String> convertContentUrls(Set<MacroTuple> macros, String baseUrl) {
        return macros.stream().map(nm -> DefaultMacroResultSetConverter.createContentUrl(nm, baseUrl)).collect(Collectors.toSet());
    }

    private static String createContentUrl(MacroTuple macroTuple, String baseUrl) {
        if (macroTuple.getContentType().equalsIgnoreCase("comment")) {
            return String.format(COMMENT_PATH, baseUrl, macroTuple.getPageId(), macroTuple.getContentId(), macroTuple.getContentId());
        }
        return DefaultMacroResultSetConverter.viewPageUrl(baseUrl, macroTuple.getContentId());
    }

    private static String viewPageUrl(String baseUrl, Long id) {
        return id == null ? null : String.format(PAGE_PATH, baseUrl, id);
    }

    private long getUniqueMacroCount(Set<MacroTuple> macroOccurrences) {
        return macroOccurrences.stream().filter(tuple -> Objects.nonNull(tuple.getSpaceId())).flatMap(this::getAllMacros).distinct().count();
    }

    private Stream<String> getAllMacros(MacroTuple macroTuple) {
        return Stream.concat(Stream.of(macroTuple.getMacro()), macroTuple.getNestedMacro().stream().flatMap(this::getNestedMacros));
    }

    private Stream<String> getNestedMacros(MacroTuple.NestedMacroTuple nestedTuple) {
        return Stream.concat(Stream.of(nestedTuple.getMacro()), nestedTuple.getChildren().stream().flatMap(this::getNestedMacros));
    }

    private long getUniqueContentCount(Set<MacroTuple> macroOccurrences) {
        return macroOccurrences.stream().filter(tuple -> Objects.nonNull(tuple.getSpaceId())).map(MacroTuple::getContentId).distinct().count();
    }

    private Map<Long, Set<MacroTuple>> groupBySpace(Collection<MacroTuple> macroOccurrences) {
        return macroOccurrences.stream().filter(tuple -> Objects.nonNull(tuple.getSpaceId())).collect(Collectors.groupingBy(MacroTuple::getSpaceId, Collectors.toSet()));
    }

    private MacroStatus getMacroStatus(MacroTuple macroTuple) {
        if (macroTuple.getContentType().equalsIgnoreCase("comment")) {
            return MacroStatus.NOT_AVAILABLE;
        }
        if (!macroTuple.getNestedMacro().isEmpty()) {
            return MacroStatus.NESTED;
        }
        return this.macroInformationSupplier.getMacroStatus(macroTuple.getMacro());
    }

    @Generated
    public DefaultMacroResultSetConverter(MacroInformationSupplier macroInformationSupplier, SystemInformationService sysInfoService, EntityManagerTemplate entityManagerTemplate) {
        this.macroInformationSupplier = macroInformationSupplier;
        this.sysInfoService = sysInfoService;
        this.entityManagerTemplate = entityManagerTemplate;
    }
}

