/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.BrowserMetricsService;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;

public class BrowserMetricOutputFileGenerator
implements AssessmentOutputFileGenerator {
    private final BrowserMetricsService browserMetricsService;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        try {
            String filename = OutputFilenames.BROWSER_METRICS.getFilename(date);
            if (example) {
                return Collections.singleton(this.browserMetricsService.exportExampleBrowserMetrics(filename, instanceMetadataDto));
            }
            return Collections.singleton(this.browserMetricsService.exportBrowserMetrics(filename, instanceMetadataDto));
        }
        catch (IOException e) {
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    @Override
    public Boolean shouldInclude(InstanceAssessmentConfig config) {
        return config.isCollectBrowserMetrics();
    }

    @Generated
    public BrowserMetricOutputFileGenerator(BrowserMetricsService browserMetricsService) {
        this.browserMetricsService = browserMetricsService;
    }
}

