/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.migration.agent.logging.GroupedThreadFactory;
import com.atlassian.migration.agent.service.FileServiceManager;
import com.atlassian.migration.agent.service.ObjectStorageService;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.catalogue.MigrationCatalogueStorageService;
import com.atlassian.migration.agent.service.catalogue.PlatformService;
import com.atlassian.migration.agent.service.check.PreflightLogger;
import com.atlassian.migration.agent.service.check.email.InvalidEmailCheckContext;
import com.atlassian.migration.agent.service.check.email.InvalidEmailChecker;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.agent.service.user.MigrationUserDto;
import com.atlassian.migration.agent.service.user.UserMigrationViaEGService;
import com.atlassian.migration.agent.service.user.request.v2.UsersMigrationV2FilePayload;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class InvalidEmailValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InvalidEmailValidator.class);
    private final InvalidEmailChecker checker;

    public InvalidEmailValidator(PlatformService platformService, CloudSiteService cloudSiteService, MigrationCatalogueStorageService migrationCatalogueStorageService, UserMigrationViaEGService userMigrationViaEGService, FileServiceManager fileServiceManager, ObjectStorageService objectStorageService, PreflightLogger preflightLogger) {
        this.checker = new InvalidEmailChecker(platformService, cloudSiteService, migrationCatalogueStorageService, userMigrationViaEGService, Executors.newCachedThreadPool(new GroupedThreadFactory("InvalidEmailValidator")), fileServiceManager, objectStorageService, preflightLogger);
    }

    public CheckResult validateInvalidEmails(String executionId, String cloudId, Collection<MigrationUser> users) {
        return this.checker.check(this.buildContext(executionId, cloudId, users));
    }

    private InvalidEmailCheckContext buildContext(String executionId, String cloudId, Collection<MigrationUser> users) {
        List<MigrationUserDto> migrationUserDtoList = users.stream().map(MigrationUserDto::from).collect(Collectors.toList());
        return new InvalidEmailCheckContext(cloudId, executionId, Collections.emptySet(), new UsersMigrationV2FilePayload(migrationUserDtoList, Collections.emptyList(), Collections.emptyMap()));
    }

    public List<EmailData> getInvalidEmails(String scanId, String cloudId, Collection<MigrationUser> allUsers) {
        CheckResult checkResult = this.validateInvalidEmails(scanId, cloudId, allUsers);
        if (checkResult.details.containsKey("executionErrorDetails")) {
            if (checkResult.details.get("executionErrorDetails").equals(PreflightErrorCode.INTERRUPTED_ERROR.getCode())) {
                throw new UncheckedInterruptedException();
            }
            throw new IllegalStateException("Error while validating invalid emails, code: " + checkResult.details.get("executionErrorDetails"));
        }
        return checkResult.details.getOrDefault("violations", Collections.emptyList());
    }
}

