/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.domain;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.domain.TrustedDomainChecker;
import com.atlassian.migration.agent.service.check.domain.TrustedDomainContext;
import com.atlassian.migration.agent.service.check.domain.TrustedDomainContextProvider;
import com.atlassian.migration.agent.service.check.domain.TrustedDomainMapper;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@ParametersAreNonnullByDefault
public class TrustedDomainCheckRegistration
implements CheckRegistration<TrustedDomainContext> {
    private final TrustedDomainChecker checker;
    private final TrustedDomainContextProvider contextProvider;
    private final TrustedDomainMapper mapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    @Inject
    public TrustedDomainCheckRegistration(TrustedDomainChecker trustedDomainChecker, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder) {
        this.checker = trustedDomainChecker;
        this.contextProvider = new TrustedDomainContextProvider();
        this.mapper = new TrustedDomainMapper();
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.TRUSTED_DOMAINS;
    }

    @Override
    public Checker<TrustedDomainContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<TrustedDomainContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.mapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(AnalyticsEventParams eventParams) {
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightTrustedDomain(eventParams.toPreflightAnalyticsEventParams());
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "trustedDomainCheck";
    }
}

