/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.webhook;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.AppsPreflightAnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckContext;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckContextProvider;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointCheckMapper;
import com.atlassian.migration.agent.service.check.app.webhook.AppWebhookEndpointChecker;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;

public class AppWebhookEndpointCheckRegistration
implements CheckRegistration<AppWebhookEndpointCheckContext> {
    private final AppWebhookEndpointChecker appWebhookEndpointChecker;
    private final AppWebhookEndpointCheckContextProvider appWebhookEndpointCheckContextProvider;
    private final AppWebhookEndpointCheckMapper appWebhookEndpointCheckMapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    @Override
    public CheckType getCheckType() {
        return CheckType.APP_WEBHOOK_ENDPOINT_CHECK;
    }

    @Override
    public Checker<AppWebhookEndpointCheckContext> getChecker() {
        return this.appWebhookEndpointChecker;
    }

    @Override
    public CheckContextProvider<AppWebhookEndpointCheckContext> getCheckContextProvider() {
        return this.appWebhookEndpointCheckContextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.appWebhookEndpointCheckMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(AnalyticsEventParams eventParams) {
        CheckResult checkResult = eventParams.getCheckResult();
        AppWebhookEndpointCheckContext appWebhookEndpointCheckContext = this.appWebhookEndpointChecker.getAppWebhookEndpointCheckContext();
        Set appWebhookCheckResult = checkResult.details.getOrDefault("appKeysMissingWebhooks", Collections.emptySet());
        Set<String> appsWithFailedCheck = appWebhookCheckResult.stream().map(it -> it.key).collect(Collectors.toSet());
        AppsPreflightAnalyticsEventParams params = eventParams.toAppsPreflightAnalyticsEventParams();
        params.addAppsFailed(appsWithFailedCheck);
        params.addAppsSucceeded(CollectionUtils.subtract(appWebhookEndpointCheckContext.appKeys, appsWithFailedCheck));
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightAppWebhookEndpointCheck(params, appWebhookEndpointCheckContext.cloudId);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "appWebhookEndpointCheck";
    }

    @Generated
    public AppWebhookEndpointCheckRegistration(AppWebhookEndpointChecker appWebhookEndpointChecker, AppWebhookEndpointCheckContextProvider appWebhookEndpointCheckContextProvider, AppWebhookEndpointCheckMapper appWebhookEndpointCheckMapper, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder) {
        this.appWebhookEndpointChecker = appWebhookEndpointChecker;
        this.appWebhookEndpointCheckContextProvider = appWebhookEndpointCheckContextProvider;
        this.appWebhookEndpointCheckMapper = appWebhookEndpointCheckMapper;
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }
}

