/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.okhttp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.List;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyTunnelEventListener
extends EventListener {
    private static final Logger log = LoggerFactory.getLogger(ProxyTunnelEventListener.class);
    private final long callStartTime = System.currentTimeMillis();

    private void logWithTiming(String event, String details) {
        long elapsed = System.currentTimeMillis() - this.callStartTime;
        log.debug("[+{}ms] {}: {}", new Object[]{elapsed, event, details});
    }

    public void callStart(Call call) {
        Request request = call.request();
        log.debug("=== OkHttp Call Started ===");
        log.debug("URL: {}", (Object)request.url());
        log.debug("Method: {}", (Object)request.method());
        this.logWithTiming("CALL_START", "HTTP call initiated");
    }

    public void proxySelectStart(Call call, HttpUrl url) {
        this.logWithTiming("PROXY_SELECT_START", "Starting proxy selection for " + url);
    }

    public void proxySelectEnd(Call call, HttpUrl url, List<Proxy> proxies) {
        this.logWithTiming("PROXY_SELECT_END", "Selected proxies: " + proxies);
        for (Proxy proxy : proxies) {
            log.debug("Proxy type: {}, Address: {}", (Object)proxy.type(), (Object)proxy.address());
        }
    }

    public void dnsStart(Call call, String domainName) {
        this.logWithTiming("DNS_START", "DNS lookup for " + domainName);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        this.logWithTiming("DNS_END", "DNS resolved " + domainName + " to " + inetAddressList);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        this.logWithTiming("CONNECT_START", "Connecting to " + inetSocketAddress + " via proxy " + proxy);
        log.debug("*** PROXY TUNNEL CREATION STARTING ***");
    }

    public void secureConnectStart(Call call) {
        this.logWithTiming("SECURE_CONNECT_START", "Starting SSL/TLS handshake");
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        this.logWithTiming("SECURE_CONNECT_END", "SSL/TLS handshake complete: " + handshake);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        this.logWithTiming("CONNECT_END", "Connected to " + inetSocketAddress + " via " + proxy + " using " + protocol);
        log.debug("*** PROXY TUNNEL CREATION COMPLETED ***");
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        this.logWithTiming("CONNECT_FAILED", "Connection failed to " + inetSocketAddress + " via " + proxy);
        log.error("*** PROXY TUNNEL CREATION FAILED ***");
        log.error("Connection failure details:", (Throwable)ioe);
        if (ioe.getMessage() != null && ioe.getMessage().contains("timeout")) {
            log.error("*** TIMEOUT DETECTED DURING TUNNEL CREATION ***");
            log.error("This is exactly where your timeout is occurring!");
        }
    }

    public void connectionAcquired(Call call, Connection connection) {
        this.logWithTiming("CONNECTION_ACQUIRED", "Acquired connection: " + connection);
        HttpUrl url = call.request().url();
        try {
            Socket socket = connection.socket();
            InetSocketAddress localAddress = (InetSocketAddress)socket.getLocalSocketAddress();
            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            log.debug("*** SOCKET CONNECTION DETAILS ***");
            log.debug("Socket URL: {}", (Object)url);
            log.debug("Socket Source (Local): {}:{}", (Object)localAddress.getAddress().getHostAddress(), (Object)localAddress.getPort());
            log.debug("Socket Destination (Remote): {}:{}", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
            log.debug("Socket Connected: {}", (Object)socket.isConnected());
            log.debug("Socket Closed: {}", (Object)socket.isClosed());
            if (remoteAddress.getPort() != 443 && remoteAddress.getPort() != 80) {
                log.debug("*** PROXY CONNECTION DETECTED ***");
                log.debug("Connected to proxy server at {}:{}", (Object)remoteAddress.getAddress().getHostAddress(), (Object)remoteAddress.getPort());
                log.debug("Target URL would be: {}", (Object)url);
            } else {
                log.debug("*** DIRECT CONNECTION DETECTED ***");
                log.debug("Direct connection to target server: {}", (Object)url.host());
            }
        }
        catch (Exception e) {
            log.warn("Could not extract socket details: {}", (Object)e.getMessage());
        }
    }

    public void connectionReleased(Call call, Connection connection) {
        this.logWithTiming("CONNECTION_RELEASED", "Released connection: " + connection);
    }

    public void requestHeadersStart(Call call) {
        this.logWithTiming("REQUEST_HEADERS_START", "Starting to send request headers");
    }

    public void requestHeadersEnd(Call call, Request request) {
        this.logWithTiming("REQUEST_HEADERS_END", "Finished sending request headers");
    }

    public void requestBodyStart(Call call) {
        this.logWithTiming("REQUEST_BODY_START", "Starting to send request body");
    }

    public void requestBodyEnd(Call call, long byteCount) {
        this.logWithTiming("REQUEST_BODY_END", "Finished sending " + byteCount + " bytes");
    }

    public void requestFailed(Call call, IOException ioe) {
        this.logWithTiming("REQUEST_FAILED", "Request failed");
        log.error("Request failure details:", (Throwable)ioe);
        if (ioe.getMessage() != null && ioe.getMessage().contains("timeout")) {
            log.error("*** WRITE TIMEOUT DETECTED ***");
            log.error("This timeout occurred during the request phase");
        }
    }

    public void responseHeadersStart(Call call) {
        this.logWithTiming("RESPONSE_HEADERS_START", "Starting to receive response headers");
    }

    public void responseHeadersEnd(Call call, Response response) {
        this.logWithTiming("RESPONSE_HEADERS_END", "Received response: " + response.code() + " " + response.message());
    }

    public void responseBodyStart(Call call) {
        this.logWithTiming("RESPONSE_BODY_START", "Starting to receive response body");
    }

    public void responseBodyEnd(Call call, long byteCount) {
        this.logWithTiming("RESPONSE_BODY_END", "Received " + byteCount + " bytes");
    }

    public void responseFailed(Call call, IOException ioe) {
        this.logWithTiming("RESPONSE_FAILED", "Response failed");
        log.error("Response failure details:", (Throwable)ioe);
    }

    public void callEnd(Call call) {
        long totalTime = System.currentTimeMillis() - this.callStartTime;
        log.debug("=== OkHttp Call Completed ===");
        log.debug("Total duration: {} ms", (Object)totalTime);
    }

    public void callFailed(Call call, IOException ioe) {
        String message;
        long totalTime = System.currentTimeMillis() - this.callStartTime;
        log.error("=== OkHttp Call Failed ===");
        log.error("Duration before failure: {} ms", (Object)totalTime);
        log.error("Final failure reason:", (Throwable)ioe);
        if (ioe.getMessage() != null && (message = ioe.getMessage().toLowerCase()).contains("timeout")) {
            log.error("*** COMPREHENSIVE TIMEOUT ANALYSIS ***");
            log.error("Timeout type: {}", (Object)ioe.getClass().getSimpleName());
            log.error("Timeout message: {}", (Object)ioe.getMessage());
            log.error("Time elapsed: {} ms", (Object)totalTime);
            if (message.contains("connect")) {
                log.error("Type: Connection timeout - Failed to establish connection to proxy");
            } else if (message.contains("write")) {
                log.error("Type: Write timeout - Failed to send data to proxy (likely CONNECT request)");
            } else if (message.contains("read")) {
                log.error("Type: Read timeout - Failed to read response from proxy");
            } else {
                log.error("Type: General timeout - Check all timeout settings");
            }
        }
    }

    public static class Factory
    implements EventListener.Factory {
        public EventListener create(Call call) {
            return new ProxyTunnelEventListener();
        }
    }
}

