/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.config.url;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.migration.agent.config.url.MigrationEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationUrlProvider {
    private Properties properties;
    private static final Logger log = LoggerFactory.getLogger(MigrationUrlProvider.class);

    public MigrationUrlProvider(MigrationEnvironment migrationEnvironment) {
        String propertiesFileName = migrationEnvironment.getFileName();
        this.properties = new Properties();
        try (InputStream inputStream = ClassLoaderUtils.getResourceAsStream((String)propertiesFileName, this.getClass());){
            this.properties.load(inputStream);
        }
        catch (IOException e) {
            log.warn("Couldn't load url from properties file", (Throwable)e);
        }
    }

    private String getProperty(String key) {
        return System.getProperty(key, this.properties.getProperty(key));
    }

    private String getProperty(String key, String defaultValue) {
        String propertiesVal = this.properties.getProperty(key, defaultValue);
        return System.getProperty(key, propertiesVal);
    }

    public String getMediaServiceUrl() {
        return this.getProperty("media.service.url");
    }

    public String getPortfolioAnalyzerServiceUrl() {
        return this.getProperty("portfolio.analyzer.service.url");
    }

    public String getMigrationAppAggregatorUrl() {
        return this.getProperty("migration.aggregator.base.url");
    }

    public String getMigrationServiceBaseUrl() {
        return this.getProperty("migration.service.base.url");
    }

    public String getUserMigrationServiceViaEGBaseUrl(String version) {
        return this.getProperty("users.migration.service.via.eg.base.url") + "/" + version;
    }

    public String getUserMigrationServiceBaseUrl() {
        return this.getProperty("users.migration.service.base.url");
    }

    public String getMigrationMappingServiceBaseUrl(String version) {
        return this.getProperty("migration.mapping.service.base.url") + "/" + version;
    }

    public String getMigrationAnalyticsServiceBaseUrl() {
        return this.getProperty("migration.analytics.base.url");
    }

    public String getAppMigrationServiceBaseUrl() {
        return this.getProperty("app.migration.service.base.url");
    }

    public String getMigrationCatalogueServiceUrl(String version) {
        return this.getProperty("migration.catalogue.service.base.url") + "/" + version;
    }

    public String getMigrationGatewayUrl() {
        return this.getProperty("migration.gateway.url");
    }

    public String getMigrationServiceGatewayURI() {
        return this.getProperty("migration.service.gateway.base.url");
    }

    public String getConfluenceCloudUrl(String version) {
        return this.getProperty("confluence.cloud.service.base.url") + "/" + version;
    }

    public String getMapiUrl(String version) {
        return this.getProperty("confluence.mapi.service.base.url") + "/" + version;
    }

    public String getPrcHostUrl() {
        return this.getProperty("prc.host.base.url");
    }

    public String getMigrationMetadataAggregatorUrl(String version) {
        return this.getProperty("migration.metadata.aggregator.service.base.url") + "/" + version;
    }

    public String getMigrationOrchestratorServiceBaseUrl() {
        return this.getProperty("migration.orchestrator.base.url");
    }

    public String getFrontendTargetCloudEnv() {
        return this.getProperty("frontend.target.cloud.env");
    }

    public String getFx3EnvironmentKey() {
        return this.getProperty("fx3.environment.key");
    }

    public String getFx3baseUrl() {
        return this.getProperty("fx3.base.url");
    }

    public String getStatsigApiKey() {
        return this.getProperty("fx3.statsig.environment.key");
    }

    public String getDefaultStatsigAppName() {
        return this.getProperty("fx3.statsig.environment.appname");
    }

    public String getMigrationExecutionEnvironment() {
        return this.getProperty("migration.execution.environment", "default");
    }
}

