/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.shadowExecutor;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.UploadState;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.shadowExecutor.ShadowMigrationExecutor;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import java.util.HashMap;
import java.util.Optional;

public class AttachmentMigrationShadowExecutor
extends ShadowMigrationExecutor {
    private final ProgressTracker progressTracker;
    private final StepStore stepStore;

    public AttachmentMigrationShadowExecutor(ProgressTracker progressTracker, StepStore stepStore) {
        super(stepStore);
        this.progressTracker = progressTracker;
        this.stepStore = stepStore;
    }

    @Override
    public StepResult performShadowMigration(String stepId, PrcTask prcTask) {
        Step step = this.stepStore.getStep(stepId);
        Step originalStep = this.getOriginalStep(prcTask, StepType.ATTACHMENT_UPLOAD);
        String spaceKey = step.getConfig();
        this.sendSuccessProgressUpdate(stepId, prcTask);
        this.sendCompletionStatus(spaceKey, prcTask, originalStep);
        return StepResult.succeeded("Shadow migration - Attachments upload has been skipped");
    }

    private void sendSuccessProgressUpdate(String stepId, PrcTask prcTask) {
        this.progressTracker.progress(stepId, 100, "Shadow migration - Attachments upload has been skipped", StepType.ATTACHMENT_UPLOAD.getDetailedStatus(), new HashMap<String, Object>(), Optional.of(prcTask));
    }

    private UploadState getOriginalResult(Step originalStep) {
        Optional<String> originalResult = originalStep.getProgress().getResult();
        return originalResult.map(s -> Jsons.readValue(s, UploadState.class)).orElse(null);
    }

    private void sendCompletionStatus(String spaceKey, PrcTask prcTask, Step originalStep) {
        String statusMessage = "Attachment shadow migration completed successfully";
        this.progressTracker.sendV4AttachmentSuccessStatus(spaceKey, prcTask, this.getOriginalResult(originalStep), statusMessage);
    }
}

