/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.reliability;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.app.reliability.AppReliabilityContext;
import com.atlassian.migration.agent.service.check.app.reliability.AppReliabilityContextProvider;
import com.atlassian.migration.agent.service.check.app.reliability.AppReliabilityMapper;
import com.atlassian.migration.agent.service.check.app.reliability.AppReliabiltityChecker;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AppReliabilityRegistration
implements CheckRegistration<AppReliabilityContext> {
    private final AppReliabiltityChecker checker;
    private final AppReliabilityContextProvider contextProvider;
    private final AppReliabilityMapper mapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public AppReliabilityRegistration(AppReliabiltityChecker appReliabiltityChecker, AppReliabilityContextProvider contextProvider, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder) {
        this.checker = appReliabiltityChecker;
        this.contextProvider = contextProvider;
        this.mapper = new AppReliabilityMapper();
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.APP_RELIABILITY;
    }

    @Override
    public Checker<AppReliabilityContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<AppReliabilityContext> getCheckContextProvider() {
        return this.contextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.mapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(AnalyticsEventParams eventParams) {
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightAppReliability(eventParams.toPreflightAnalyticsEventParams(), 0);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "appReliabilityCheck";
    }
}

