/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.pollers;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.service.ClusterInformationService;
import com.atlassian.migration.agent.service.check.V4PollerLogger;
import com.atlassian.migration.agent.service.metrics.PollingMetrics;
import com.atlassian.migration.agent.service.planning.TaskPlanningEngine;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.prc.PrcOkHttpAdapter;
import com.atlassian.migration.agent.service.stepexecutor.ProgressTracker;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.InProgressMigrationIds;
import com.atlassian.migration.agent.v4.pollers.PollerConfig;
import com.atlassian.migration.agent.v4.pollers.StatusPoller;
import com.atlassian.migration.agent.v4.pollers.V4Poller;
import com.atlassian.migration.agent.v4.pollers.status.StatusRetreivalService;
import com.atlassian.migration.agent.v4.tasks.TransferTask;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.util.UUID;

public class PollerFactory {
    private OnDemandPrcPoller prcPoller;
    private final InProgressMigrationIds migrationIds;
    private final PollerConfigHandler pollerConfigHandler;
    private final SystemInformationService systemInformationService;
    private final StatusRetreivalService statusRetreivalService;
    private final TaskStore taskStore;
    private final PlanStore planStore;
    private final PluginTransactionTemplate ptx;
    private final PrcOkHttpAdapter prcOkHttpAdapter;
    private final EventPublisher eventPublisher;
    private final TaskPlanningEngine taskPlanningEngine;
    private final ProgressTracker progressTracker;
    private final PollingMetrics pollerMetrics;
    private final V4PollerLogger v4PollerLogger;
    private final ClusterInformationService clusterInformationService;
    private final MigrationAgentConfiguration migrationAgentConfiguration;

    public PollerFactory(InProgressMigrationIds migrationIds, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, StatusRetreivalService statusRetreivalService, PlanStore planStore, TaskStore taskStore, PluginTransactionTemplate ptx, SystemInformationService systemInformationService, PrcOkHttpAdapter prcOkHttpAdapter, MigrationAgentConfiguration migrationAgentConfiguration, EventPublisher eventPublisher, TaskPlanningEngine taskPlanningEngine, ProgressTracker progressTracker, PollingMetrics pollerMetrics, V4PollerLogger v4PollerLogger, ClusterInformationService clusterInformationService) {
        this.migrationIds = migrationIds;
        this.prcPoller = prcPoller;
        this.ptx = ptx;
        this.planStore = planStore;
        this.taskStore = taskStore;
        this.statusRetreivalService = statusRetreivalService;
        this.pollerConfigHandler = pollerConfigHandler;
        this.systemInformationService = systemInformationService;
        this.prcOkHttpAdapter = prcOkHttpAdapter;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.eventPublisher = eventPublisher;
        this.taskPlanningEngine = taskPlanningEngine;
        this.progressTracker = progressTracker;
        this.pollerMetrics = pollerMetrics;
        this.v4PollerLogger = v4PollerLogger;
        this.clusterInformationService = clusterInformationService;
    }

    public <T extends TransferTask> V4Poller<T> createWorkPoller(PollerConfig config, V4Worker<T> worker) {
        return new V4Poller<T>((Object)((Object)worker.getTransferTaskType()) + "-" + UUID.randomUUID(), worker, config, this.prcPoller, this.migrationIds, this.pollerConfigHandler, this.systemInformationService, this.prcOkHttpAdapter, this.migrationAgentConfiguration, this.pollerMetrics, this.v4PollerLogger, this.clusterInformationService);
    }

    public StatusPoller createStatusPoller(PollerConfig config, InProgressMigrationIds migrationIds) {
        return new StatusPoller("status-poller-" + UUID.randomUUID(), config.getPollingDelay(), migrationIds, this.ptx, this.planStore, this.taskStore, this.statusRetreivalService, this.eventPublisher, this.taskPlanningEngine, this.progressTracker, this.v4PollerLogger, this.clusterInformationService);
    }
}

