/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.entity;

import com.atlassian.migration.statusrouter.model.CommandStatus;

public enum TransferStatus {
    READY,
    IN_PROGRESS,
    SUCCESS,
    FAILED,
    INCOMPLETE,
    TIMED_OUT,
    SKIPPED,
    CANCELLING,
    CANCELLED;


    public CommandStatus toCommandStatus() {
        switch (this) {
            case SUCCESS: {
                return CommandStatus.SUCCESS;
            }
            case FAILED: {
                return CommandStatus.FAILED;
            }
            case INCOMPLETE: {
                return CommandStatus.INCOMPLETE;
            }
            case SKIPPED: {
                return CommandStatus.SKIPPED;
            }
            case TIMED_OUT: {
                return CommandStatus.TIMED_OUT;
            }
            case CANCELLED: {
                return CommandStatus.CANCELLED;
            }
        }
        throw new IllegalArgumentException("Unsupported conversion to Command status of transfer status " + this.name());
    }

    public static TransferStatus fromCommandStatus(CommandStatus commandStatus) {
        switch (commandStatus) {
            case SUCCESS: {
                return SUCCESS;
            }
            case FAILED: {
                return FAILED;
            }
            case INCOMPLETE: {
                return INCOMPLETE;
            }
            case SKIPPED: {
                return SKIPPED;
            }
            case TIMED_OUT: {
                return TIMED_OUT;
            }
            case CANCELLED: {
                return CANCELLED;
            }
        }
        throw new IllegalArgumentException("Unsupported conversion from CommandStatus: " + commandStatus.name());
    }

    public boolean isTerminal() {
        return this == SUCCESS || this == FAILED || this == INCOMPLETE || this == SKIPPED || this == TIMED_OUT || this == CANCELLED;
    }
}

