/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.impl;

import com.atlassian.migration.agent.entity.Preflight;
import com.atlassian.migration.agent.store.PreflightStore;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.base.Strings;
import java.time.Instant;

public class PreflightStoreImpl
implements PreflightStore {
    private final EntityManagerTemplate tmpl;

    public PreflightStoreImpl(EntityManagerTemplate tmpl) {
        this.tmpl = tmpl;
    }

    @Override
    public Preflight create(Preflight preflight) {
        Instant now = Instant.now();
        preflight.setCreatedAt(now);
        this.tmpl.persist(preflight);
        return preflight;
    }

    @Override
    public void persistPlanId(String checkExecutionId, String planId) {
        if (Strings.isNullOrEmpty((String)checkExecutionId) || Strings.isNullOrEmpty((String)planId)) {
            return;
        }
        this.tmpl.query("update Preflight p set p.planId=:planId where p.executionId=:checkExecutionId and p.planId is NULL").param("planId", (Object)planId).param("checkExecutionId", (Object)checkExecutionId).update();
    }

    @Override
    public long getCountFromPlanName(String planName) {
        if (Strings.isNullOrEmpty((String)planName)) {
            return 0L;
        }
        return this.tmpl.query(Long.class, "select count(*) from Preflight p where p.planName=:planName").param("planName", (Object)planName).single();
    }
}

