/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.entity.MapiArtifacts;
import com.atlassian.migration.agent.store.MapiArtifactsStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class MapiArtifactsService {
    private final PluginTransactionTemplate ptx;
    private final MapiArtifactsStore mapiArtifactsStore;

    public MapiArtifactsService(PluginTransactionTemplate ptx, MapiArtifactsStore mapiArtifactsStore) {
        this.ptx = ptx;
        this.mapiArtifactsStore = mapiArtifactsStore;
    }

    public void saveOrUpdate(MapiArtifacts mapiArtifacts) {
        this.ptx.write(() -> {
            mapiArtifacts.setLastUpdate(Instant.now());
            this.mapiArtifactsStore.saveOrUpdate(mapiArtifacts);
            return null;
        });
    }

    public void deleteArtifact(String taskId, String checkName) {
        this.ptx.write(() -> {
            this.mapiArtifactsStore.deleteArtifact(taskId, checkName);
            return null;
        });
    }

    public void deleteArtifactByTaskId(String taskId) {
        this.ptx.write(() -> {
            this.mapiArtifactsStore.deleteArtifactByTaskId(taskId);
            return null;
        });
    }

    public Optional<MapiArtifacts> getArtifact(String taskId, String checkName) {
        return this.ptx.read(() -> this.mapiArtifactsStore.getArtifact(taskId, checkName));
    }

    public List<MapiArtifacts> getArtifactsByTaskId(String taskId) {
        return this.ptx.read(() -> this.mapiArtifactsStore.getArtifactsByTaskId(taskId));
    }
}

