/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.remote.CloudJobType;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentConfigClient;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentUploadService;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightPrcCommandExecutor
implements Runnable,
Consumer<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InsightPrcCommandExecutor.class);
    private final InstanceAssessmentUploadService instanceAssessmentUploadService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final InstanceAssessmentConfigClient instanceAssessmentConfigClient;

    public InsightPrcCommandExecutor(InstanceAssessmentUploadService instanceAssessmentUploadService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, InstanceAssessmentConfigClient instanceAssessmentConfigClient) {
        this.instanceAssessmentUploadService = instanceAssessmentUploadService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.instanceAssessmentConfigClient = instanceAssessmentConfigClient;
    }

    @Override
    public void run() {
        this.runAssessments(true, this.instanceAssessmentConfigClient.getDefaultConfig());
    }

    @Override
    public void accept(@Nullable String s) {
        InstanceAssessmentConfig config = InstanceAssessmentConfig.deserialize(s).orElse(this.instanceAssessmentConfigClient.getDefaultConfig());
        this.runAssessments(config.isCollectBrowserMetrics() || config.isCollectUsageMetrics(), config);
    }

    private void runAssessments(boolean enableBrowserMetricsFeature, InstanceAssessmentConfig config) {
        try {
            if (enableBrowserMetricsFeature) {
                this.verifyAndEnableAssessments();
            }
            this.instanceAssessmentUploadService.runAssessments(CloudJobType.ASSESSMENT, config);
        }
        catch (Exception e) {
            log.error("Error while starting instance assessment remotely", (Throwable)e);
            try {
                this.instanceAssessmentUploadService.failInCloud(CloudJobType.ASSESSMENT);
            }
            catch (Exception ex) {
                log.error("Error while calling failInCloud", (Throwable)e);
            }
        }
    }

    private void verifyAndEnableAssessments() {
        if (!this.migrationDarkFeaturesManager.isL1AssessmentEnabled()) {
            try {
                this.migrationDarkFeaturesManager.enableL1Assessments();
            }
            catch (Exception ex) {
                log.error("Error while enabling browser metrics", (Throwable)ex);
            }
            if (!this.migrationDarkFeaturesManager.isL1AssessmentEnabled()) {
                throw new IllegalStateException("Failed to enable browser metrics feature");
            }
        }
    }
}

