/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.stepexecutor.attachment;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.AttachmentsMigrationDetails;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.service.UploadState;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import lombok.Generated;

public class AttachmentsUploadTracker {
    private final AtomicLong numOfUploadedAttachments = new AtomicLong();
    private final AtomicLong numOfFailedAttachments = new AtomicLong();
    private final AtomicLong uploadedBytes = new AtomicLong();
    private final long numOfAttachments;
    private final long totalSizeToUpload;
    private final long totalSize;
    private final long numOfAttachmentsAlreadyMigrated;
    private final Consumer<UploadState> onProgress;
    private AtomicLong lastProgressUpdateTime = new AtomicLong(System.currentTimeMillis());
    private static final Long PROGRESS_UPDATE_DELAY_THRESHOLD_IN_MS = 1800000L;
    private AtomicBoolean stuckAttachmentsMigrationEventRaised = new AtomicBoolean(false);
    private final Consumer<AttachmentsMigrationDetails> onProgressStuck;
    private final Step step;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;

    AttachmentsUploadTracker(long numOfAttachments, long totalSize, long numOfAttachmentsAlreadyMigrated, long totalSizeToUpload, Consumer<UploadState> onProgress, Consumer<AttachmentsMigrationDetails> onProgressStuck, Step step, MigrationDarkFeaturesManager darkFeaturesManager) {
        this.numOfAttachments = numOfAttachments;
        this.totalSize = totalSize;
        this.numOfAttachmentsAlreadyMigrated = numOfAttachmentsAlreadyMigrated;
        this.onProgress = onProgress;
        this.totalSizeToUpload = totalSizeToUpload;
        this.onProgressStuck = onProgressStuck;
        this.step = step;
        this.migrationDarkFeaturesManager = darkFeaturesManager;
    }

    UploadState getUploadState() {
        return new UploadState(this.numOfUploadedAttachments.get(), this.numOfAttachments, this.numOfFailedAttachments.get(), this.uploadedBytes.get(), this.totalSize, this.totalSizeToUpload, this.numOfAttachmentsAlreadyMigrated);
    }

    void checkDelayAndUpdateUploadedBytes(long uploadedBytes) {
        if (this.migrationDarkFeaturesManager.isStuckAttachmentsMigrationDetectionEnabled()) {
            long delay = System.currentTimeMillis() - this.lastProgressUpdateTime.get();
            if (delay > PROGRESS_UPDATE_DELAY_THRESHOLD_IN_MS && this.stuckAttachmentsMigrationEventRaised.compareAndSet(false, true)) {
                Instant migrationStartTime = this.step.getPlan().getProgress().getStartTime().orElse(null);
                AttachmentsMigrationDetails attachmentsMigrationDetails = AttachmentsMigrationDetails.builder().uploadState(this.getUploadState()).step(this.step).lastProgressUpdateTime(this.lastProgressUpdateTime.get()).migrationStartTime(migrationStartTime).build();
                this.onProgressStuck.accept(attachmentsMigrationDetails);
            }
            this.lastProgressUpdateTime.set(System.currentTimeMillis());
        }
        this.addUploadedBytes(uploadedBytes);
    }

    void addUploadedBytes(long uploadedBytes) {
        this.uploadedBytes.addAndGet(uploadedBytes);
        this.onProgress.accept(this.getUploadState());
    }

    void attachmentUploaded() {
        this.numOfUploadedAttachments.incrementAndGet();
        this.onProgress.accept(this.getUploadState());
    }

    void attachmentUploadFailed() {
        this.numOfFailedAttachments.incrementAndGet();
        this.onProgress.accept(this.getUploadState());
    }

    @Generated
    public AtomicLong getNumOfUploadedAttachments() {
        return this.numOfUploadedAttachments;
    }

    @Generated
    public AtomicLong getNumOfFailedAttachments() {
        return this.numOfFailedAttachments;
    }

    @Generated
    public AtomicLong getUploadedBytes() {
        return this.uploadedBytes;
    }

    @Generated
    public long getNumOfAttachments() {
        return this.numOfAttachments;
    }

    @Generated
    public long getTotalSizeToUpload() {
        return this.totalSizeToUpload;
    }

    @Generated
    public long getTotalSize() {
        return this.totalSize;
    }

    @Generated
    public long getNumOfAttachmentsAlreadyMigrated() {
        return this.numOfAttachmentsAlreadyMigrated;
    }

    @Generated
    public Consumer<UploadState> getOnProgress() {
        return this.onProgress;
    }

    @Generated
    public AtomicLong getLastProgressUpdateTime() {
        return this.lastProgressUpdateTime;
    }

    @Generated
    public AtomicBoolean getStuckAttachmentsMigrationEventRaised() {
        return this.stuckAttachmentsMigrationEventRaised;
    }

    @Generated
    public Consumer<AttachmentsMigrationDetails> getOnProgressStuck() {
        return this.onProgressStuck;
    }

    @Generated
    public Step getStep() {
        return this.step;
    }

    @Generated
    public MigrationDarkFeaturesManager getMigrationDarkFeaturesManager() {
        return this.migrationDarkFeaturesManager;
    }
}

