/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.entity.InstanceAnalysisControl;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlService;
import com.atlassian.migration.agent.service.guardrails.InstanceAnalysisControlTypes;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentService;
import com.atlassian.migration.agent.service.guardrails.remote.InstanceAssessmentConfigClient;
import com.atlassian.migration.agent.service.guardrails.usage.AccessLogProcessingJobRunner;
import com.atlassian.migration.agent.store.guardrails.AssessmentDuration;
import com.atlassian.migration.agent.store.guardrails.AssessmentStatus;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAnalysisControlStore;
import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AssessmentJobProgressService {
    private static final Logger log = ContextLoggerFactory.getLogger(AssessmentJobProgressService.class);
    private static final String COLLECTION_BROWSER_METRICS = "Collecting browser metrics";
    private final InstanceAnalysisControlStore instanceAnalysisControlStore;
    private final InstanceAnalysisControlService instanceAnalysisControlService;
    private final MigrationDarkFeaturesManager featuresManager;
    private static final String SERVER_NODE = "serverNode";
    private static final int TIME_IN_MINUTES = 60;
    private final InstanceAssessmentService instanceAssessmentService;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;
    private final AccessLogProcessingJobRunner accessLogProcessingJobRunner;
    private final InstanceAssessmentConfigClient instanceAssessmentConfigClient;

    public AssessmentJobProgressService(InstanceAnalysisControlStore instanceAnalysisControlStore, InstanceAnalysisControlService instanceAnalysisControlService, MigrationDarkFeaturesManager featuresManager, GuardrailsResponseGroupStore guardrailsResponseGroupStore, InstanceAssessmentService instanceAssessmentService, AccessLogProcessingJobRunner accessLogProcessingJobRunner, InstanceAssessmentConfigClient instanceAssessmentConfigClient) {
        this.instanceAnalysisControlStore = instanceAnalysisControlStore;
        this.instanceAnalysisControlService = instanceAnalysisControlService;
        this.featuresManager = featuresManager;
        this.instanceAssessmentService = instanceAssessmentService;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
        this.accessLogProcessingJobRunner = accessLogProcessingJobRunner;
        this.instanceAssessmentConfigClient = instanceAssessmentConfigClient;
    }

    public AssessmentStatus processJobProgress() {
        AssessmentStatus assessmentStatus = this.getAssessmentStatus();
        if (assessmentStatus.getStatus() == InstanceAssessmentStatus.COMPLETE) {
            return this.featuresManager.isNewAssessmentStatusDisabled() ? AssessmentStatus.completedAssessmentOld(assessmentStatus.getFinishDate()) : AssessmentStatus.completedAssessment(assessmentStatus.getFinishDate());
        }
        return assessmentStatus;
    }

    @NotNull
    private AssessmentStatus getAssessmentStatus() {
        return this.guardrailsResponseGroupStore.findLast().map(guardrailsResponseGroup -> {
            Optional<InstanceAnalysisControl> instanceAnalysisControl;
            InstanceAssessmentConfig config = InstanceAssessmentConfig.deserialize(guardrailsResponseGroup.getConfigJson()).orElse(this.instanceAssessmentConfigClient.getDefaultConfig());
            if (this.featuresManager.isL1AssessmentEnabled() && config.isLongRunning() && (instanceAnalysisControl = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent()) {
                return this.getBrowserMetricsProgress(instanceAnalysisControl.get());
            }
            return this.getGrQueriesProgress((GuardrailsResponseGroup)guardrailsResponseGroup);
        }).orElseGet(AssessmentStatus::notStartedAssessment);
    }

    private AssessmentStatus getGrQueriesProgress(GuardrailsResponseGroup guardrailsResponseGroup) {
        String jobId = guardrailsResponseGroup.getJobId();
        try {
            Set<JobDetails> activeJobsDetails = this.instanceAssessmentService.getActiveJobs();
            Set activeJobs = activeJobsDetails.stream().map(JobDetails::getJobId).map(Object::toString).collect(Collectors.toSet());
            log.info("Current jobId is:{} and number of running jobs are:{}", (Object)jobId, (Object)activeJobs.size());
            if (activeJobs.contains(jobId)) {
                Pair<Duration, Long> progress = this.instanceAssessmentService.getJobProgress(jobId);
                if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                    return AssessmentStatus.inProgressAssessmentOld(progress.getRight() + "% COMPLETE");
                }
                return AssessmentStatus.inProgressAssessment(((Duration)progress.getLeft()).toMillis(), (Long)progress.getRight(), "Collecting guardrails, " + progress.getRight() + "% COMPLETE");
            }
            if (guardrailsResponseGroup.isCanceled()) {
                return AssessmentStatus.cancelAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
            }
            log.info("Job completed for jobId:{}", (Object)jobId);
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.completedAssessmentOld(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
            }
            return AssessmentStatus.completedAssessment(Instant.ofEpochMilli(guardrailsResponseGroup.getEndTimestamp()));
        }
        catch (Exception e) {
            log.error("Failed to get progress for jobId:{}", (Object)jobId, (Object)e);
            return AssessmentStatus.failedAssessment();
        }
    }

    private AssessmentStatus getBrowserMetricsProgress(InstanceAnalysisControl instanceAnalysisControl) {
        if (this.instanceAnalysisControlStore.isFinished(instanceAnalysisControl)) {
            if (!this.accessLogProcessingJobRunner.isFinished()) {
                if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                    return AssessmentStatus.inProgressAssessmentOld("0 h 1 m remaining");
                }
                return AssessmentStatus.inProgressAssessment(1000L, 99L, COLLECTION_BROWSER_METRICS);
            }
            Long endTimestamp = instanceAnalysisControl.getEndTimestamp();
            Timestamp tms = new Timestamp(endTimestamp);
            Date completedDate = new Date(tms.getTime());
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.completedAssessmentOld(completedDate.toInstant());
            }
            if (instanceAnalysisControl.isCanceled()) {
                return AssessmentStatus.cancelAssessment(completedDate.toInstant());
            }
            return AssessmentStatus.completedAssessment(completedDate.toInstant());
        }
        Duration remainingDuration = this.instanceAnalysisControlService.calculateRemainingDuration(instanceAnalysisControl);
        if (remainingDuration.isZero()) {
            this.finishAssessmentCollection();
        }
        if (this.featuresManager.isNewAssessmentStatusDisabled()) {
            return AssessmentStatus.inProgressAssessmentOld(remainingDuration.toHours() + " h " + remainingDuration.toMinutes() % 60L + " m remaining");
        }
        long percentage = 100L - remainingDuration.toMillis() * 100L / this.instanceAnalysisControlService.assessmentDuration().toMillis();
        return AssessmentStatus.inProgressAssessment(remainingDuration.toMillis(), percentage, COLLECTION_BROWSER_METRICS);
    }

    private void finishAssessmentCollection() {
        log.info("Stopping Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.finishAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }

    public AssessmentStatus scheduleInstanceAssessment(boolean cloudTriggered, InstanceAssessmentConfig defaultConfig) throws SchedulerServiceException {
        Set<JobDetails> activeJobs;
        Optional<InstanceAnalysisControl> currentInstanceAnalysis;
        InstanceAssessmentConfig resolvedConfig = this.resolveConfiguration(defaultConfig, cloudTriggered);
        log.info("Will use following config for Assessment: {}", (Object)resolvedConfig);
        if (this.featuresManager.isL1AssessmentEnabled()) {
            this.accessLogProcessingJobRunner.startAssessment(resolvedConfig);
        }
        if ((currentInstanceAnalysis = this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name())).isPresent() && !this.instanceAnalysisControlStore.isFinished(currentInstanceAnalysis.get())) {
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.inProgressAssessmentOld(this.processJobProgress().getDescription());
            }
            AssessmentStatus status = this.processJobProgress();
            return AssessmentStatus.inProgressAssessment(status.getRemainingDuration(), status.getPercentage(), status.getDescription());
        }
        if (this.featuresManager.isL1AssessmentEnabled()) {
            this.instanceAnalysisControlService.startAssessmentCollection(cloudTriggered, resolvedConfig);
        }
        if (!(activeJobs = this.instanceAssessmentService.getActiveJobs()).isEmpty()) {
            JobDetails job = activeJobs.iterator().next();
            String jobId = job.getJobId().toString();
            Map map = job.getParameters();
            String nodeId = (String)map.get(SERVER_NODE);
            log.info("Job already running for nodeId: {} and jobId:{}", (Object)nodeId, (Object)jobId);
            if (this.featuresManager.isNewAssessmentStatusDisabled()) {
                return AssessmentStatus.inProgressAssessmentOld(this.processJobProgress().getDescription());
            }
            AssessmentStatus status = this.processJobProgress();
            return AssessmentStatus.inProgressAssessment(status.getRemainingDuration(), status.getPercentage(), status.getDescription());
        }
        log.info("There are no active jobs");
        this.instanceAssessmentService.scheduleJob(cloudTriggered, resolvedConfig);
        return AssessmentStatus.newAssessment();
    }

    private InstanceAssessmentConfig resolveConfiguration(InstanceAssessmentConfig initialConfig, boolean cloudTriggered) {
        if (cloudTriggered) {
            log.info("Running instance assessment with job config: {}", (Object)initialConfig);
            return initialConfig;
        }
        return this.instanceAssessmentConfigClient.resolveConfig(initialConfig);
    }

    public AssessmentStatus cancelAssessmentCollection() {
        InstanceAssessmentStatus status = this.processJobProgress().getStatus();
        if (status.equals((Object)InstanceAssessmentStatus.IN_PROGRESS)) {
            this.cancelGuardrailsCollection();
            this.cancelBrowserMetricsCollection();
            return AssessmentStatus.cancelAssessment(Instant.now());
        }
        return AssessmentStatus.notStartedAssessment();
    }

    private void cancelGuardrailsCollection() {
        this.instanceAssessmentService.cancelAssessmentCollection();
    }

    private void cancelBrowserMetricsCollection() {
        log.info("Cancelling Assessment Collection.");
        if (this.instanceAnalysisControlService.findInstanceAnalysisControl(InstanceAnalysisControlTypes.BROWSER_METRICS.name()).isPresent()) {
            this.instanceAnalysisControlService.cancelAssessmentCollection();
            this.accessLogProcessingJobRunner.cleanup();
        }
    }

    public AssessmentDuration getTotalJobDuration(boolean cloudTriggered, InstanceAssessmentConfig config) {
        InstanceAssessmentConfig resolvedConfig = this.resolveConfiguration(config, cloudTriggered);
        if (this.featuresManager.isL1AssessmentEnabled() && resolvedConfig.isLongRunning()) {
            return new AssessmentDuration(this.instanceAnalysisControlService.assessmentDuration().toMillis());
        }
        return new AssessmentDuration(this.instanceAssessmentService.getTotalAssessmentApproxDuration(resolvedConfig).toMillis());
    }
}

