/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.featureflag;

import com.atlassian.fx3.Fx3Client;
import com.atlassian.fx3.statsig.DynamicConfigAttributes;
import com.atlassian.fx3.statsig.DynamicConfigValue;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.url.MigrationEnvironment;
import com.atlassian.migration.agent.service.featureflag.Fx3ClientFactory;
import com.atlassian.migration.agent.service.featureflag.StatsigDynamicConfigs;
import com.atlassian.migration.agent.service.featureflag.StatsigFeatureGateNameMapper;
import com.atlassian.migration.agent.service.util.StatsigUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFlagClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureFlagClient.class);
    private Fx3Client fx3Client;
    private Fx3Client fx3ClientFedramp;
    private final StatsigFeatureGateNameMapper statsigFeatureGateNameMapper;
    private Fx3Client fx3ActiveClient;
    private final Fx3ClientFactory fx3ClientFactory;

    public FeatureFlagClient(Fx3ClientFactory fx3ClientFactory, StatsigFeatureGateNameMapper statsigFeatureGateNameMapper) {
        this.fx3ClientFactory = fx3ClientFactory;
        this.statsigFeatureGateNameMapper = statsigFeatureGateNameMapper;
    }

    public Fx3Client getFx3ClientFedramp() {
        if (this.fx3ClientFedramp == null) {
            this.fx3ClientFedramp = this.fx3ClientFactory.createFx3Client(MigrationEnvironment.FEDRAMP);
        }
        return this.fx3ClientFedramp;
    }

    public Fx3Client getFx3Client() {
        if (this.fx3Client == null) {
            this.fx3Client = this.fx3ClientFactory.createFx3Client(MigrationEnvironment.DEFAULT);
        }
        return this.fx3Client;
    }

    public void updateCloudId(String cloudId) {
        try {
            this.getFx3ActiveClient().updateUserIdentifier(cloudId);
            this.getFx3ActiveClient().performManualFetch();
        }
        catch (Exception e) {
            log.error("Error occurred while updating cloud id", (Throwable)e);
        }
    }

    public DynamicConfigAttributes getConfigAttributesFromStatsig(String configName) {
        return this.getFx3ActiveClient().getConfigFromStatsig(configName);
    }

    public void updateCustomAttributes(Map<String, Object> customAttributes) {
        try {
            this.getFx3ActiveClient().updateUserCustomAttributes(customAttributes);
        }
        catch (Exception e) {
            log.error("Error occurred while updating custom attributes", (Throwable)e);
        }
    }

    public boolean isFeatureEnabled(MigrationDarkFeaturesManager.FeatureFlags featureFlag) {
        return this.isFeatureEnabled(featureFlag, false);
    }

    public boolean isFeatureEnabled(MigrationDarkFeaturesManager.FeatureFlags flagKey, boolean defaultValue) {
        try {
            return this.isGateEnabledInStatsig(flagKey.getFlagName()) || this.getFx3ActiveClient().getAllEnabledFlagsForUser().contains(flagKey.getFlagName());
        }
        catch (Exception e) {
            log.error("Error occurred while checking feature flag", (Throwable)e);
            return defaultValue;
        }
    }

    public List<String> getAllEnabledFeatureFlags() {
        try {
            Set ldFlags = this.getFx3ActiveClient().getAllEnabledFlagsForUser();
            Set statsigFlags = this.getFx3ActiveClient().getAllEnabledGatesForUserFromStatsig().stream().map(this.statsigFeatureGateNameMapper::getFeatureFlagName).filter(Objects::nonNull).collect(Collectors.toSet());
            HashSet result = new HashSet();
            result.addAll(ldFlags);
            result.addAll(statsigFlags);
            return new ArrayList<String>(result);
        }
        catch (Exception e) {
            log.error("Error occurred while getting all enabled feature flags", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private boolean isGateEnabledInStatsig(String flagKey) {
        return Boolean.TRUE.equals(this.getFx3ActiveClient().getGateFromStatsig(flagKey).getValue());
    }

    public Object getConfigValueByName(String configName) {
        StatsigDynamicConfigs statsigConfig = StatsigUtils.getConfigByName(configName);
        if (statsigConfig == null) {
            log.warn("No config was found under config name : {}", (Object)configName);
            return null;
        }
        return this.getConfigValue(statsigConfig);
    }

    public Object getConfigValue(StatsigDynamicConfigs config) {
        DynamicConfigAttributes configAttributes = this.getConfigAttributesFromStatsig(config.getConfigName());
        DynamicConfigValue configValue = configAttributes.getValue();
        Object defaultValue = config.getDefaultValue();
        if (configValue == null || configValue.getValue() == null) {
            return defaultValue;
        }
        switch (config.getConfigType()) {
            case NUMBER: {
                return StatsigUtils.getNumberConfigValue(configAttributes);
            }
            case BOOLEAN: {
                return StatsigUtils.getBooleanConfigValue(configAttributes);
            }
            case STRING: {
                return StatsigUtils.getStringConfigValue(configAttributes);
            }
            case NUMBER_LIST: {
                return StatsigUtils.getListOfNumbersConfigValue(configAttributes);
            }
            case STRING_LIST: {
                return StatsigUtils.getListOfStringConfigValue(configAttributes);
            }
        }
        return defaultValue;
    }

    public Map<String, Object> getAllConfigsFromStatsig() {
        Map configMap = this.getFx3ActiveClient().getAllConfigsForUserFromStatsig();
        return configMap.entrySet().stream().collect(Collectors.toMap(entry -> {
            String newKey = this.statsigFeatureGateNameMapper.getFeatureFlagName((String)entry.getKey());
            return newKey != null ? newKey : (String)entry.getKey();
        }, Map.Entry::getValue));
    }

    public Set<String> getAllEnabledStatsigConfigs() {
        Map<String, Object> configMap = this.getAllConfigsFromStatsig();
        return configMap.entrySet().stream().filter(entry -> entry.getValue() instanceof Boolean && (Boolean)entry.getValue() != false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Generated
    public StatsigFeatureGateNameMapper getStatsigFeatureGateNameMapper() {
        return this.statsigFeatureGateNameMapper;
    }

    @Generated
    public Fx3Client getFx3ActiveClient() {
        return this.fx3ActiveClient;
    }

    @Generated
    public Fx3ClientFactory getFx3ClientFactory() {
        return this.fx3ClientFactory;
    }

    @Generated
    public void setFx3Client(Fx3Client fx3Client) {
        this.fx3Client = fx3Client;
    }

    @Generated
    public void setFx3ClientFedramp(Fx3Client fx3ClientFedramp) {
        this.fx3ClientFedramp = fx3ClientFedramp;
    }

    @Generated
    public void setFx3ActiveClient(Fx3Client fx3ActiveClient) {
        this.fx3ActiveClient = fx3ActiveClient;
    }
}

