/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.cloud;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.dto.CloudType;
import com.atlassian.migration.agent.mma.model.MetadataRefreshStatus;
import com.atlassian.migration.agent.mma.model.token.CreateContainerTokenRequest;
import com.atlassian.migration.agent.mma.model.token.CreateContainerTokenResponse;
import com.atlassian.migration.agent.mma.service.MigrationMetadataAggregatorService;
import com.atlassian.migration.agent.service.catalogue.EnterpriseGatekeeperClient;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.cloud.LegalService;
import com.atlassian.migration.agent.service.impl.DetectedUserEmailAnalyticsService;
import com.atlassian.migration.agent.service.prc.PrcClientService;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerTokenService {
    private static final Logger log = LoggerFactory.getLogger(ContainerTokenService.class);
    private final EnterpriseGatekeeperClient enterpriseGatekeeperClient;
    private final transient DetectedUserEmailAnalyticsService detectedUserEmailAnalyticsService;
    private final transient CloudSiteService cloudSiteService;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final transient LegalService legalService;
    private final PrcClientService prcClientService;
    private final transient MigrationMetadataAggregatorService migrationMetadataAggregatorService;

    public ContainerTokenService(EnterpriseGatekeeperClient enterpriseGatekeeperClient, DetectedUserEmailAnalyticsService detectedUserEmailAnalyticsService, CloudSiteService cloudSiteService, MigrationDarkFeaturesManager migrationDarkFeaturesManager, LegalService legalService, PrcClientService prcClientService, MigrationMetadataAggregatorService migrationMetadataAggregatorService) {
        this.enterpriseGatekeeperClient = enterpriseGatekeeperClient;
        this.detectedUserEmailAnalyticsService = detectedUserEmailAnalyticsService;
        this.cloudSiteService = cloudSiteService;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.legalService = legalService;
        this.prcClientService = prcClientService;
        this.migrationMetadataAggregatorService = migrationMetadataAggregatorService;
    }

    public void createAndSaveToken(String authToken, String cloudUrl) {
        CreateContainerTokenRequest request = new CreateContainerTokenRequest("CONFLUENCE", URI.create(cloudUrl));
        CreateContainerTokenResponse createContainerTokenResponse = this.enterpriseGatekeeperClient.createContainerToken(request, authToken);
        this.saveToken(createContainerTokenResponse.getCloudUrl().toString(), createContainerTokenResponse.getCloudId(), Edition.findByKey((String)createContainerTokenResponse.getCloudEdition()), CloudType.STANDARD.name(), createContainerTokenResponse.getToken(), null);
    }

    public boolean saveToken(String cloudUrl, String cloudId, Optional<Edition> edition, String cloudType, String containerToken, String cloudOrigin) {
        block5: {
            log.info("Saving container token for cloudUrl: {}", (Object)cloudUrl);
            CloudType type = CloudType.valueOf(cloudType);
            this.cloudSiteService.createOrUpdate(cloudId, cloudUrl, containerToken, edition, type);
            this.detectedUserEmailAnalyticsService.triggerForCloudId(cloudId);
            if (cloudOrigin != null && !this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled()) {
                return false;
            }
            try {
                if (this.migrationDarkFeaturesManager.isCloudFirstMigrationEnabled() && type == CloudType.STANDARD) {
                    this.prcClientService.attachUntilTokenExpiry(cloudUrl);
                    MetadataRefreshStatus metadataRefreshStatus = this.migrationMetadataAggregatorService.upsertServerInstanceCloudSitePairInMMA(containerToken, cloudId);
                    if (metadataRefreshStatus == MetadataRefreshStatus.FAILURE && cloudOrigin != null) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while connecting to MMA: [{}]\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
                if (cloudOrigin == null) break block5;
                return false;
            }
        }
        this.legalService.rememberLegalOptIn();
        return true;
    }
}

