/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.catalogue;

import com.atlassian.migration.agent.Tracker;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.ExecutionStatus;
import com.atlassian.migration.agent.entity.MigrationStatus;
import com.atlassian.migration.agent.entity.Plan;
import com.atlassian.migration.agent.entity.TransferStatus;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.mapi.entity.MapiStatusDto;
import com.atlassian.migration.agent.mapi.external.model.ArtifactResponse;
import com.atlassian.migration.agent.mapi.external.model.JobDefinitionResponse;
import com.atlassian.migration.agent.media.MediaConfigToken;
import com.atlassian.migration.agent.mma.model.AppMetadata;
import com.atlassian.migration.agent.mma.model.DomainMetadataDTO;
import com.atlassian.migration.agent.mma.model.EntityActionDTO;
import com.atlassian.migration.agent.mma.model.MetadataRefreshState;
import com.atlassian.migration.agent.mma.model.ServerInstanceDTO;
import com.atlassian.migration.agent.mma.model.SpaceMetadataDTO;
import com.atlassian.migration.agent.mma.model.processor.MetadataBatch;
import com.atlassian.migration.agent.mma.model.token.CreateContainerTokenRequest;
import com.atlassian.migration.agent.mma.model.token.CreateContainerTokenResponse;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementRegisterRequest;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementRegisterResponse;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementUpdateRequest;
import com.atlassian.migration.agent.model.infraoptimisation.DataMovementUpdateResponse;
import com.atlassian.migration.agent.model.infraoptimisation.ResourceOptimisationStatusResponse;
import com.atlassian.migration.agent.okhttp.HttpResponseWithHeader;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.MediaTypes;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.okhttp.ServiceErrorCodeHandler;
import com.atlassian.migration.agent.service.ConfluenceImportExportTaskStatus;
import com.atlassian.migration.agent.service.GlobalEntitiesImportContextDto;
import com.atlassian.migration.agent.service.MCSUploadPath;
import com.atlassian.migration.agent.service.SpaceImportContextDto;
import com.atlassian.migration.agent.service.catalogue.ContainerCreateRequest;
import com.atlassian.migration.agent.service.catalogue.ContainersFetchResponse;
import com.atlassian.migration.agent.service.catalogue.ContainersUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationCreateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationCreateRequestV2;
import com.atlassian.migration.agent.service.catalogue.MigrationDetails;
import com.atlassian.migration.agent.service.catalogue.MigrationScopeCreateRequest;
import com.atlassian.migration.agent.service.catalogue.MigrationScopeDetails;
import com.atlassian.migration.agent.service.catalogue.Space;
import com.atlassian.migration.agent.service.catalogue.TransferProgressRequest;
import com.atlassian.migration.agent.service.catalogue.TransferStatusUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.TransferStatusesUpdateRequest;
import com.atlassian.migration.agent.service.catalogue.model.AbstractContainer;
import com.atlassian.migration.agent.service.catalogue.model.CloudPageTemplate;
import com.atlassian.migration.agent.service.catalogue.model.CompleteMultipartFileUploadRequest;
import com.atlassian.migration.agent.service.catalogue.model.CreateFileRequest;
import com.atlassian.migration.agent.service.catalogue.model.CreateSinglepartFileResponse;
import com.atlassian.migration.agent.service.catalogue.model.ErrorLogsArtifactRequest;
import com.atlassian.migration.agent.service.catalogue.model.MigrationDomainsAllowlistResponse;
import com.atlassian.migration.agent.service.catalogue.model.MigrationMappingPage;
import com.atlassian.migration.agent.service.catalogue.model.PagedResponse;
import com.atlassian.migration.agent.service.catalogue.model.SpaceResponse;
import com.atlassian.migration.agent.service.catalogue.model.StorageFileDownloadResponse;
import com.atlassian.migration.agent.service.catalogue.model.StorageFileResponse;
import com.atlassian.migration.agent.service.catalogue.model.TeamCalendarPresenceResponse;
import com.atlassian.migration.agent.service.catalogue.model.TransferResponseList;
import com.atlassian.migration.agent.service.catalogue.model.UploadFilePartMCSResponse;
import com.atlassian.migration.agent.service.catalogue.model.UploadFilePartS3Response;
import com.atlassian.migration.agent.service.catalogue.model.UploadFilePartToPresignedURLResponse;
import com.atlassian.migration.agent.service.check.email.InvalidEmailCheckRequest;
import com.atlassian.migration.agent.service.cloud.CloudSiteService;
import com.atlassian.migration.agent.service.confluence.request.BulkSpaceImportStatusRequest;
import com.atlassian.migration.agent.service.confluence.request.BulkSpaceImportStatusResponse;
import com.atlassian.migration.agent.service.confluence.request.GlobalEntitiesImportPayload;
import com.atlassian.migration.agent.service.confluence.request.SpaceImportV2Payload;
import com.atlassian.migration.agent.service.execution.UncheckedInterruptedException;
import com.atlassian.migration.agent.service.impl.StargateHelper;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.agent.service.user.EmailCheckStatusResponse;
import com.atlassian.migration.agent.service.user.LicenceCheckRequest;
import com.atlassian.migration.agent.service.user.LicenceCheckStatusResponse;
import com.atlassian.migration.agent.service.user.MigrationResponse;
import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import com.atlassian.migration.agent.v4.migration.PlatformMigrationStatus;
import com.atlassian.migration.agent.v4.recipe.RecipeExecutionActionRequest;
import com.atlassian.migration.app.ContainerType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedSupplier;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class EnterpriseGatekeeperClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnterpriseGatekeeperClient.class);
    private static final String ENTITY_TYPE_KEY = "entityType";
    private static final String ID_PREFIX_FILTER_KEY = "idPrefixFilter";
    private static final String LAST_ENTITY_KEY = "lastEntity";
    private static final String PAGE_SIZE_KEY = "pageSize";
    private static final int PAGE_SIZE = 1000;
    private static final String SKIP_CONTAINERS_WITHOUT_SELECTIONS = "skipContainersWithoutSelections";
    private static final String MULTIPART = "MULTIPART";
    private static final String SINGLEPART = "SINGLEPART";
    public static final int LARGE_FILE_SIZE = 0x6400000;
    public static final int MAX_PART_SIZE = 0x1000000;
    private static final String ETAG_HEADER = "ETag";
    private static final String MIGRATION_PATH = "/migration";
    public static final String MIGRATION_ALLOWLIST_PATH = "/migration/allowlist/CONFLUENCE";
    private static final String STORAGE_FILE_PATH = "/storage/file/";
    private static final String CONTAINER_PATH = "/container";
    private static final String TRANSFER_PATH = "/transfer";
    private static final String PROGRESS_PATH = "/progress";
    private static final String SCOPE_PATH = "/scope";
    private static final String MAPI_PATH = "/cma/jobs";
    private static final String MAPI_TOKEN_PATH = "/cma/token";
    private static final String MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM = "cloudId";
    private static final String MIGRATION_METADATA_AGGREGATOR_SERVER_ID_QUERY_PARAM = "serverId";
    private static final String MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_PATH = "/spaces";
    private static final String MIGRATION_METADATA_AGGREGATOR_USER_METADATA_PATH = "/users";
    private static final String MIGRATION_METADATA_AGGREGATOR_APPS_METADATA_PATH = "/apps";
    private static final String MIGRATION_METADATA_AGGREGATOR_DOMAINS_METADATA_PATH = "/domains";
    private static final String MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_SINGLE_ENTITY_PATH = "/cloudSite/%s/server/%s/confluence/space";
    private static final String MIGRATION_METADATA_AGGREGATOR_SERVER_PATH = "/server";
    private static final String MIGRATION_METADATA_AGGREGATOR_STATUS_UPDATE_PATH = "/cloudSite/%s/server/%s/refreshstate";
    private static final String STATUS_PATH = "/status";
    private static final String MCS_CHECKSUM_HEADER = "Content-SHA";
    private static final String AMZ_CHECKSUM_HEADER = "x-amz-checksum-sha256";
    public static final String CLOUD_ID_HEADER = "Cloud-Id";
    private static final String CLOUD_ID = "cloudid";
    private static final String IMPORT_PATH = "import";
    private static final String BULK_IMPORT_PATH = "/import/spaces";
    private static final String V1 = "v1";
    private static final String V2 = "v2";
    private static final int SPACES_BATCH_SIZE = 1000;
    private static final String SPACE_PATH = "space";
    private static final int PAGE_TEMPLATES_BATCH_SIZE = 200;
    private static final String PAGE_TEMPLATES_PATH = "template/page";
    private static final String CONFLUENCE_LIMIT_QUERY_PARAM = "limit";
    private static final String CONFLUENCE_START_QUERY_PARAM = "start";
    private static final String EMPTY_PREFIX = "";
    private static final Integer CONNECTION_TIMEOUT_SECONDS = 5;
    private static final boolean SHOULD_FOLLOW_REDIRECTS = true;
    private static final boolean SHOULD_FOLLOW_SSL_REDIRECTS = true;
    private static final Integer READ_TIMEOUT_SECONDS = 60;
    private static final Integer WRITE_TIMEOUT_SECONDS = 60;
    private static final Integer DEFAULT_MAX_IDLE_CONNECTIONS = 5;
    private static final Long ATLASSIAN_KEEP_ALIVE_DURATION_SECONDS = 55L;
    public static final String BATCHING_QUERY_PARAM = "batch";
    private static final String MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_DELETE_PATH = "/cloudSite/%s/server/%s/confluence/space/%s";
    private static final String MAPI_STOP_RECIPE = "/cma/migration/%s/lio/recipe-executions/actions";
    private static final String DATA_MOVEMENT_REGISTER_API = "/migration/%s/jdmcc/data-movement/register";
    private static final String GET_RESOURCE_OPTIMISATION_STATUS_API = "/migration/%s/jdmcc/data-movement/%s/resource-optimisation/status";
    private static final String DATA_MOVEMENT_UPDATE_API = "/migration/%s/jdmcc/data-movement/%s/status";
    private static final String DATA_TYPE_KEY = "dataType";
    private static final String DATA_TYPE = "ATLASSIAN";
    private static final String MAPPING = "/mapping";
    private final HttpService httpService;
    private final MigrationAgentConfiguration configuration;
    private final CloudSiteService cloudSiteService;
    private final boolean bypassStargate;
    private final RetryPolicy<Response> responseRetryPolicy;
    private final Gson gson = new Gson();

    public EnterpriseGatekeeperClient(MigrationAgentConfiguration configuration, UserAgentInterceptor userAgentInterceptor, CloudSiteService cloudSiteService, OKHttpProxyBuilder okHttpProxyBuilder) {
        this(new HttpService(() -> EnterpriseGatekeeperClient.buildHttpClientWithCustomKeepAliveTimeout(userAgentInterceptor, okHttpProxyBuilder), new ServiceErrorCodeHandler()), configuration, cloudSiteService, RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicy().build());
    }

    @VisibleForTesting
    EnterpriseGatekeeperClient(HttpService httpService, MigrationAgentConfiguration configuration, CloudSiteService cloudSiteService, RetryPolicy<Response> responseRetryPolicy) {
        this.bypassStargate = configuration.isBypassStargate();
        this.httpService = httpService;
        this.configuration = configuration;
        this.cloudSiteService = cloudSiteService;
        this.responseRetryPolicy = responseRetryPolicy;
    }

    @VisibleForTesting
    static OkHttpClient buildHttpClientWithCustomKeepAliveTimeout(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout((long)Math.toIntExact(Duration.ofSeconds(Long.getLong("ccma.connect.timeout", CONNECTION_TIMEOUT_SECONDS.intValue())).toMillis()), TimeUnit.MILLISECONDS).followRedirects(true).followSslRedirects(true).readTimeout((long)Math.toIntExact(Duration.ofSeconds(Long.getLong("ccma.read.timeout", READ_TIMEOUT_SECONDS.intValue())).toMillis()), TimeUnit.MILLISECONDS).writeTimeout((long)Math.toIntExact(Duration.ofSeconds(Long.getLong("ccma.write.timeout", WRITE_TIMEOUT_SECONDS.intValue())).toMillis()), TimeUnit.MILLISECONDS).addInterceptor((Interceptor)userAgentInterceptor).connectionPool(new ConnectionPool(DEFAULT_MAX_IDLE_CONNECTIONS.intValue(), ATLASSIAN_KEEP_ALIVE_DURATION_SECONDS.longValue(), TimeUnit.SECONDS)).build();
    }

    MigrationDetails createMigrationV2(String cloudId, MigrationCreateRequestV2 migrationCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V2).path(MIGRATION_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)migrationCreateRequest))).build();
        return this.callGsonWithRetries(request, MigrationDetails.class);
    }

    MigrationDetails createMigration(String cloudId, MigrationCreateRequest migrationCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)migrationCreateRequest))).build();
        return this.callGsonWithRetries(request, MigrationDetails.class);
    }

    void createContainers(String cloudId, String migrationId, ContainerCreateRequest containerCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)containerCreateRequest))).build();
        this.callWithRetries(request);
    }

    public ConfluenceImportExportTaskStatus initiateGlobalEntitiesImport(String cloudId, String containerToken, GlobalEntitiesImportContextDto importContext) {
        GlobalEntitiesImportPayload globalEntitiesImportPayload = new GlobalEntitiesImportPayload(importContext.getMigrationScopeId(), importContext.getMigrationId(), importContext.getFiles());
        UriComponentsBuilder importEndpointUriBuilder = this.getConfluenceUriBuilder(V2);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId, IMPORT_PATH, "nonspace"}).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(globalEntitiesImportPayload), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public ConfluenceImportExportTaskStatus getGlobalEntitiesImportProgress(String cloudId, String containerToken, String taskId) {
        Objects.requireNonNull(taskId);
        UriComponentsBuilder importEndpointUriBuilder = this.getConfluenceUriBuilder(V2);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId, IMPORT_PATH, "nonspace", "taskid", taskId}).toUriString()).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public ConfluenceImportExportTaskStatus initiateConfluenceSpaceImport(String cloudId, String containerToken, SpaceImportContextDto spaceImportContext) {
        UriComponentsBuilder importEndpointUriBuilder = this.getConfluenceUriBuilder(V2);
        SpaceImportV2Payload spaceImportPayload = new SpaceImportV2Payload(spaceImportContext.getFileId(), spaceImportContext.getPlanId(), spaceImportContext.getMigrationScopeId(), spaceImportContext.getMigrationId(), spaceImportContext.getFiles());
        importEndpointUriBuilder.queryParam(BATCHING_QUERY_PARAM, new Object[]{true});
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId, IMPORT_PATH}).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(spaceImportPayload), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public ConfluenceImportExportTaskStatus getConfluenceSpaceImportProgress(String cloudId, String containerToken, String confTaskId) {
        Objects.requireNonNull(confTaskId);
        UriComponentsBuilder importEndpointUriBuilder = this.getConfluenceUriBuilder(V2);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId, IMPORT_PATH, "taskid", confTaskId}).toUriString()).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ConfluenceImportExportTaskStatus>(){});
    }

    public BulkSpaceImportStatusResponse getBulkConfluenceSpaceImportProgress(String cloudId, String containerToken, List<String> confTaskIds) {
        Objects.requireNonNull(confTaskIds);
        BulkSpaceImportStatusRequest requestPayload = new BulkSpaceImportStatusRequest(confTaskIds);
        UriComponentsBuilder importEndpointUriBuilder = this.getConfluenceUriBuilder(V2);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(importEndpointUriBuilder.pathSegment(new String[]{CLOUD_ID, cloudId}).path(BULK_IMPORT_PATH).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(requestPayload), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callJson(request, new TypeReference<BulkSpaceImportStatusResponse>(){});
    }

    public Map<String, String> getMappings(String cloudId, String migrationScopeId, String entityType, String idPrefixFilter) {
        MigrationMappingPage page;
        String lastEntity2 = null;
        HashMap<String, String> mappings = new HashMap<String, String>();
        do {
            page = this.getMappingsPage(cloudId, migrationScopeId, entityType, idPrefixFilter, lastEntity2);
            lastEntity2 = page.getMeta().getLastEntity();
            mappings.putAll(page.getItems());
        } while (lastEntity2 != null && !lastEntity2.isEmpty() && page.getMeta().isHasNext());
        return mappings;
    }

    public MigrationScopeDetails createMigrationScope(String cloudId, MigrationScopeCreateRequest migrationScopeCreateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(SCOPE_PATH).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)migrationScopeCreateRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, MigrationScopeDetails.class);
    }

    public JobDefinitionResponse getMigrationJobDefinition(String jobId, String containerToken) {
        Request request = StargateHelper.requestBuilder(containerToken, this.bypassStargate).url(this.getMapiUriBuilder(V1).path(MAPI_PATH).pathSegment(new String[]{jobId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, JobDefinitionResponse.class, (Set<Integer>)ImmutableSet.of((Object)HttpStatus.METHOD_NOT_ALLOWED.value()));
    }

    public void stopRecipe(RecipeExecutionActionRequest recipeExecutionActionRequest, String cloudId, String containerToken) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMapiUriBuilder(V1).path(String.format(MAPI_STOP_RECIPE, recipeExecutionActionRequest.getExecutionId())).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)recipeExecutionActionRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetries(request);
    }

    public void sendMappingsUpdate(String cloudId, String migrationScopeId, String entityType, Map<String, String> mapping) {
        UriComponentsBuilder builder = this.getMmsUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path(MAPPING).queryParam(ENTITY_TYPE_KEY, new Object[]{entityType}).queryParam(DATA_TYPE_KEY, new Object[]{DATA_TYPE});
        RequestBody requestBody = RequestBody.create((String)this.gson.toJson(mapping), (MediaType)MediaTypes.APPLICATION_JSON_TYPE);
        Request request = this.getJsonBuilder(cloudId).url(builder.toUriString()).put(requestBody).build();
        this.callWithRetries(request);
    }

    private MigrationMappingPage getMappingsPage(String cloudId, String migrationScopeId, String entityType, String idPrefixFilter, @Nullable String lastEntity2) {
        UriComponentsBuilder builder = this.getMmsUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path("/mapping/page").queryParam(ENTITY_TYPE_KEY, new Object[]{entityType}).queryParam(ID_PREFIX_FILTER_KEY, new Object[]{idPrefixFilter}).queryParam(PAGE_SIZE_KEY, new Object[]{1000});
        if (lastEntity2 != null) {
            builder = builder.queryParam(LAST_ENTITY_KEY, new Object[]{lastEntity2});
        }
        Request request = this.getJsonBuilder(cloudId).url(builder.toUriString()).get().build();
        return this.callGsonWithRetries(request, MigrationMappingPage.class);
    }

    ContainersFetchResponse getContainersForMigration(String cloudId, String migrationId, AbstractContainer.ContainerType type, int pageSize, @Nullable String nextId, boolean expand, boolean skipContainersWithoutSelections) {
        UriComponentsBuilder uri = this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).queryParam(PAGE_SIZE_KEY, new Object[]{pageSize}).queryParam(SKIP_CONTAINERS_WITHOUT_SELECTIONS, new Object[]{skipContainersWithoutSelections});
        if (Objects.nonNull((Object)type)) {
            uri.queryParam("containerType", new Object[]{type});
        }
        if (expand) {
            uri.queryParam("expand", new Object[]{"TRANSFERS"});
        }
        if (StringUtils.isNotEmpty((CharSequence)nextId)) {
            uri.queryParam("nextId", new Object[]{nextId});
        }
        Request request = this.getJsonBuilder(cloudId).url(uri.toUriString()).get().build();
        HttpResponseWithHeader<ContainersFetchResponse> response = this.callGsonWithRetriesResponseHeader(request, ContainersFetchResponse.class);
        ContainersFetchResponse responseBody = response.getResponseBody();
        responseBody.setStatus(PlatformMigrationStatus.valueOf(response.getHeaders().get("X-Atlassian-Migration-Status")));
        return responseBody;
    }

    ContainersFetchResponse getContainersByStatusForMigration(String cloudId, String migrationId, ContainerType type, AbstractContainer.ContainerStatus status, int pageSize, @Nullable String nextId) {
        UriComponentsBuilder uri = this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).queryParam("containerType", new Object[]{type}).queryParam("status", new Object[]{status}).queryParam(PAGE_SIZE_KEY, new Object[]{pageSize});
        if (StringUtils.isNotEmpty((CharSequence)nextId)) {
            uri.queryParam("nextId", new Object[]{nextId});
        }
        Request request = this.getJsonBuilder(cloudId).url(uri.toUriString()).get().build();
        return this.callGsonWithRetries(request, ContainersFetchResponse.class);
    }

    void updateContainerStatus(String cloudId, String migrationId, String containerId, AbstractContainer.ContainerStatus status, @Nullable String statusMessage) {
        ContainersUpdateRequest containersUpdateRequest = new ContainersUpdateRequest(status, statusMessage);
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).pathSegment(new String[]{containerId}).path(STATUS_PATH).toUriString()).put(RequestBody.create((String)this.gson.toJson((Object)containersUpdateRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetriesForSendingMCSStatus(request);
    }

    public StorageFileResponse createStorageFileInMCS(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath) {
        return this.createStorageFileInMCS(cloudId, migrationId, fileName, mcsUploadPath, EMPTY_PREFIX);
    }

    public StorageFileResponse createStorageFileInMCS(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath, String prefix) {
        log.info("MULTIPART - Creating file in MCS cloudId: {} for {}: {} fileName: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileName});
        Request request = this.buildCreateStorageFileRequest(cloudId, migrationId, fileName, MULTIPART, mcsUploadPath, prefix);
        return this.callGsonWithRetries(request, StorageFileResponse.class);
    }

    public CreateSinglepartFileResponse createStorageFileInMCSSinglePart(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath) {
        return this.createStorageFileInMCSSinglePart(cloudId, migrationId, fileName, mcsUploadPath, EMPTY_PREFIX);
    }

    public CreateSinglepartFileResponse createStorageFileInMCSSinglePart(String cloudId, String migrationId, String fileName, MCSUploadPath mcsUploadPath, String prefix) {
        log.info("SINGLEPART - Creating file in MCS cloudId: {} for {} : {} fileName: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileName});
        Request request = this.buildCreateStorageFileRequest(cloudId, migrationId, fileName, SINGLEPART, mcsUploadPath, prefix);
        return this.callGsonWithRetries(request, CreateSinglepartFileResponse.class);
    }

    @NotNull
    private Request buildCreateStorageFileRequest(String cloudId, String migrationId, String fileName, String uploadMethod, MCSUploadPath mcsUploadPath, String prefix) {
        return this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path("/storage/file").queryParam("uploadMethod", new Object[]{uploadMethod}).queryParam("useSha256", new Object[]{true}).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)new CreateFileRequest(fileName, prefix)), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
    }

    public StorageFileDownloadResponse getFileDownloadUrlFromMCS(String cloudId, String migrationId, String fileId, MCSUploadPath mcsUploadPath) {
        log.info("Get file download url in MCS cloudId: {} for {} : {} fileId: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileId});
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path(STORAGE_FILE_PATH).pathSegment(new String[]{fileId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, StorageFileDownloadResponse.class);
    }

    public MediaConfigToken getMediaConfigToken(String cloudId, String containerToken, Duration expiryDuration) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getConfluenceUriBuilder(V1).pathSegment(new String[]{CLOUD_ID, cloudId}).path("/media/config/token").queryParam("expiryDuration", new Object[]{expiryDuration.toMinutes()}).toUriString()).get().build();
        return this.callGsonWithRetriesForFetchingMediaToken(request, MediaConfigToken.class);
    }

    public MigrationResponse startEmailCheck(String cloudId, String migrationScopeId, InvalidEmailCheckRequest invalidEmailCheckRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildInvalidEmailsCheckUrl(migrationScopeId).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)invalidEmailCheckRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, MigrationResponse.class);
    }

    public EmailCheckStatusResponse getInvalidEmailsCheckStatus(String cloudId, String migrationScopeId, String taskId) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildInvalidEmailsCheckUrl(migrationScopeId).pathSegment(new String[]{taskId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, EmailCheckStatusResponse.class);
    }

    public LicenceCheckStatusResponse getLicenceCheckStatus(String cloudId, String migrationScopeId, String taskId) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildLicenceCheckUrl(migrationScopeId).pathSegment(new String[]{taskId}).toUriString()).get().build();
        return this.callGsonWithRetries(request, LicenceCheckStatusResponse.class);
    }

    public MigrationResponse startLicenceCheck(String cloudId, String migrationScopeId, LicenceCheckRequest licenceCheckRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildLicenceCheckUrl(migrationScopeId).toUriString()).post(RequestBody.create((String)this.gson.toJson((Object)licenceCheckRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callGsonWithRetries(request, MigrationResponse.class);
    }

    public MigrationDomainsAllowlistResponse getDomainAllowlist(String cloudId) {
        Request request = this.getJsonBuilder(cloudId).url(this.buildDomainAllowlistUrl().toUriString()).get().build();
        return this.callGsonWithRetries(request, MigrationDomainsAllowlistResponse.class);
    }

    private static String getSHA256CheckSum(long partSize, FileInputStream file) throws IOException {
        byte[] filePart = new byte[(int)partSize];
        file.read(filePart, 0, filePart.length);
        MessageDigest sha256Digest = DigestUtils.getSha256Digest();
        sha256Digest.update(filePart);
        return Base64.encodeBase64String((byte[])sha256Digest.digest());
    }

    private UriComponentsBuilder getUserMigrationUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getUserMigrationServiceViaEGBaseUrl(version));
    }

    private UriComponentsBuilder buildInvalidEmailsCheckUrl(String migrationScopeId) {
        return this.getUserMigrationUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path("/confluence/check/emails");
    }

    private UriComponentsBuilder buildLicenceCheckUrl(String migrationScopeId) {
        return this.getUserMigrationUriBuilder(V1).path(SCOPE_PATH).pathSegment(new String[]{migrationScopeId}).path("check/licence/");
    }

    public void uploadFileToMCS(String cloudId, String migrationId, String fileId, String uploadId, Path filePath, MCSUploadPath mcsUploadPath, Tracker ... trackers) {
        try {
            log.info("Uploading file cloudId: {} migrationId: {} fileId: {} uploadId: {} filename: {}", new Object[]{cloudId, migrationId, fileId, uploadId, filePath.toAbsolutePath()});
            try (FileInputStream file = new FileInputStream(filePath.toFile());){
                this.uploadMultipartFile(cloudId, migrationId, fileId, uploadId, file, mcsUploadPath, trackers);
            }
        }
        catch (UncheckedInterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file: " + filePath.getFileName(), e);
        }
        catch (Exception e) {
            log.error("Error occurred when uploading file to MCS", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void uploadMultipartFile(String cloudId, String migrationId, String fileId, String uploadId, FileInputStream file, MCSUploadPath mcsUploadPath, Tracker ... trackers) {
        try {
            long fileSize = file.getChannel().size();
            long partSize = 0x1000000L;
            long bytesRemaining = fileSize;
            ArrayList<UploadFilePartS3Response> fileParts = new ArrayList<UploadFilePartS3Response>();
            ArrayList<String> checksums = new ArrayList<String>();
            int index = 1;
            while (bytesRemaining > 0L) {
                long offSet = (long)(index - 1) * 0x1000000L;
                if (bytesRemaining < partSize) {
                    partSize = bytesRemaining;
                }
                StopConditionCheckingUtil.throwIfStopConditionWasReached();
                UploadFilePartToPresignedURLResponse uploadFilePartToPresignedURLResponse = this.uploadFilePartToPresignedURL(cloudId, migrationId, fileId, uploadId, offSet, index, partSize, file, mcsUploadPath);
                Response response = uploadFilePartToPresignedURLResponse.getResponse();
                String checkSum = uploadFilePartToPresignedURLResponse.getChecksum();
                fileParts.add(this.processUploadResponse(index, response));
                checksums.add(checkSum);
                if (trackers.length > 0) {
                    trackers[0].track(partSize);
                }
                bytesRemaining -= partSize;
                ++index;
            }
            this.completeMultipartUpload(cloudId, migrationId, fileId, uploadId, fileParts, checksums, mcsUploadPath);
        }
        catch (UncheckedInterruptedException | ClosedByInterruptException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (Exception e) {
            log.error("Error uploading file, fileId: {}, migrationId: {}", new Object[]{fileId, migrationId, e});
            throw new RuntimeException(e);
        }
    }

    private UploadFilePartToPresignedURLResponse uploadFilePartToPresignedURL(String cloudId, String migrationId, String fileId, String uploadId, long offSet, int index, long partSize, FileInputStream file, MCSUploadPath mcsUploadPath) throws IOException {
        String checkSum = EnterpriseGatekeeperClient.getSHA256CheckSum(partSize, file);
        UploadFilePartMCSResponse presignedURL = this.requestMultipartPresignedURL(cloudId, migrationId, fileId, uploadId, index, mcsUploadPath, checkSum);
        Response response = this.uploadFilePartToPresignedURL(presignedURL, offSet, partSize, file, checkSum);
        return new UploadFilePartToPresignedURLResponse(response, checkSum);
    }

    private Response uploadFilePartToPresignedURL(UploadFilePartMCSResponse result, final long offSet, final long partSize, final FileInputStream file, String checkSum) {
        try {
            Request uploadRequest = new Request.Builder().url(result.getUploadUrl()).addHeader(AMZ_CHECKSUM_HEADER, checkSum).put(new RequestBody(){

                public long contentLength() {
                    return partSize;
                }

                public MediaType contentType() {
                    return MediaTypes.APPLICATION_STREAM_TYPE;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    if (partSize > 0L) {
                        file.getChannel().position(offSet);
                        sink.write(Okio.source((InputStream)file), partSize);
                    }
                }
            }).build();
            return this.callWithRetriesAndReturnResponse(uploadRequest);
        }
        catch (IllegalArgumentException exception) {
            log.error("Error while uploading the file part", (Throwable)exception);
            throw exception;
        }
    }

    private String getMigrationOrScopePathSegment(MCSUploadPath mcsUploadPath) {
        return mcsUploadPath == MCSUploadPath.MIGRATION_ID ? MIGRATION_PATH : SCOPE_PATH;
    }

    @NotNull
    private UploadFilePartS3Response processUploadResponse(int index, Response uploadResponse) {
        String etag = uploadResponse.header(ETAG_HEADER);
        if (etag == null) {
            throw new RuntimeException("No ETag found in header during upload file part in index: " + index);
        }
        return new UploadFilePartS3Response(index, etag);
    }

    private UploadFilePartMCSResponse requestMultipartPresignedURL(String cloudId, String migrationId, String fileId, String uploadId, int index, MCSUploadPath mcsUploadPath, String checksum) {
        Request.Builder jsonBuilder = this.getJsonBuilder(cloudId);
        String buildUploadFilePart = this.buildUploadFilePartUrl(migrationId, fileId, uploadId, index, mcsUploadPath).toUriString();
        Request request = jsonBuilder.url(buildUploadFilePart).addHeader(MCS_CHECKSUM_HEADER, checksum).post(RequestBody.create(null, (byte[])new byte[0])).build();
        return this.callGsonWithRetries(request, UploadFilePartMCSResponse.class);
    }

    private UriComponentsBuilder buildUploadFilePartUrl(String migrationId, String fileId, String uploadId, int index, MCSUploadPath mcsUploadPath) {
        return this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path(STORAGE_FILE_PATH).pathSegment(new String[]{fileId}).path("/upload").pathSegment(new String[]{uploadId}).path("/part/").pathSegment(new String[]{Integer.toString(index)});
    }

    void completeMultipartUpload(String cloudId, String migrationId, String fileId, String uploadId, List<UploadFilePartS3Response> fileParts, List<String> checksums, MCSUploadPath mcsUploadPath) {
        log.info("Complete multipart upload for cloudId: {} for {} : {}, fileId: {}, # of file parts: {}", new Object[]{cloudId, mcsUploadPath.getValue(), migrationId, fileId, fileParts.size()});
        CompleteMultipartFileUploadRequest completeMultipartFileUploadRequest = new CompleteMultipartFileUploadRequest(fileParts, checksums);
        Request completeUploadRequest = this.getJsonBuilder(cloudId).url(this.buildCompleteUploadUrl(migrationId, fileId, uploadId, mcsUploadPath)).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson((Object)completeMultipartFileUploadRequest))).build();
        Response completeMultipartUploadResponse = this.callWithRetriesAndReturnResponse(completeUploadRequest);
        if (completeMultipartUploadResponse.code() != 204) {
            throw new RuntimeException("Error while completing multipart file upload in MCS status code: " + completeMultipartUploadResponse.code());
        }
    }

    private String buildCompleteUploadUrl(String migrationId, String fileId, String uploadId, MCSUploadPath mcsUploadPath) {
        return this.getUriBuilder(V1).path(this.getMigrationOrScopePathSegment(mcsUploadPath)).pathSegment(new String[]{migrationId}).path(STORAGE_FILE_PATH).pathSegment(new String[]{fileId}).path("/upload").pathSegment(new String[]{uploadId}).path("/complete").toUriString();
    }

    private UriComponentsBuilder buildDomainAllowlistUrl() {
        return this.getUriBuilder(V1).path(MIGRATION_ALLOWLIST_PATH);
    }

    private UriComponentsBuilder getUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationCatalogueServiceUrl(version));
    }

    private UriComponentsBuilder getConfluenceUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getConfluenceCloudUrl(version));
    }

    private UriComponentsBuilder getMapiUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMapiUrl(version));
    }

    private UriComponentsBuilder getMigrationMetadataAggregatorUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationMetadataAggregatorUrl(version));
    }

    private UriComponentsBuilder getMmsUriBuilder(String version) {
        return UriComponentsBuilder.fromHttpUrl((String)this.configuration.getMigrationMappingServiceBaseUrl(version));
    }

    private Request.Builder getJsonBuilder(String cloudId) {
        return StargateHelper.requestBuilder(this.getContainerToken(cloudId), this.bypassStargate).addHeader(CLOUD_ID_HEADER, cloudId).addHeader("Accept", "application/json");
    }

    private Request.Builder getJsonBuilder(String cloudId, String containerToken) {
        return StargateHelper.requestBuilder(containerToken, this.bypassStargate).addHeader(CLOUD_ID_HEADER, cloudId).addHeader("Accept", "application/json");
    }

    private Request.Builder getJsonBuilderWithContainerToken(String containerToken) {
        return StargateHelper.requestBuilder(containerToken, this.bypassStargate).addHeader("Accept", "application/json");
    }

    private String getContainerToken(String cloudId) {
        Optional<CloudSite> cloudSite = this.cloudSiteService.getByCloudId(cloudId);
        if (!cloudSite.isPresent()) {
            throw new IllegalStateException(String.format("Failed to find cloudSite entry for requested cloudId: %s", cloudId));
        }
        return cloudSite.get().getContainerToken();
    }

    private void callWithRetries(Request request) {
        this.withStopConditionExceptionHandling(() -> (Response)Failsafe.with(this.responseRetryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.call(request)));
    }

    private void callWithRetriesForSendingMCSStatus(Request request) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicyForLongerDuration().build();
        this.withStopConditionExceptionHandling(() -> (Response)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.call(request)));
    }

    private <T> T callGsonWithRetries(Request request, Class<T> bodyType) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicy().build();
        return this.withStopConditionExceptionHandling(() -> Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callGson(request, bodyType)));
    }

    private <T> T callGsonWithRetriesForFetchingMediaToken(Request request, Class<T> bodyType) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicyForLongerDuration().build();
        return this.withStopConditionExceptionHandling(() -> Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callGson(request, bodyType)));
    }

    private <T> T callGsonWithRetries(Request request, Class<T> bodyType, Set<Integer> expectedErrorCodes) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicy().build();
        return this.withStopConditionExceptionHandling(() -> Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callGsonWithExpectedErrorCodes(request, bodyType, expectedErrorCodes)));
    }

    public Response callWithRetriesAndReturnResponse(Request request) {
        return (Response)this.withStopConditionExceptionHandling(() -> (Response)Failsafe.with(this.responseRetryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.call(request)));
    }

    public Response callStreamWithRetriesAndReturnResponse(Request request, Set<Integer> expectedErrorCodes) {
        return (Response)this.withStopConditionExceptionHandling(() -> (Response)Failsafe.with(this.responseRetryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callStream(request, expectedErrorCodes)));
    }

    public Response callStreamAndReturnResponse(Request request, Set<Integer> expectedErrorCodes) {
        return (Response)this.withStopConditionExceptionHandling(() -> this.httpService.callStream(request, expectedErrorCodes));
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicy().build();
        return this.withStopConditionExceptionHandling(() -> Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callJson(request, bodyType)));
    }

    private <T> T callJson(Request request, TypeReference<T> bodyType) {
        return this.withStopConditionExceptionHandling(() -> this.httpService.callJson(request, bodyType));
    }

    private <T> HttpResponseWithHeader<T> callGsonWithRetriesResponseHeader(Request request, Class<T> bodyType) {
        RetryPolicy retryPolicy = RetryPolicyBuilder.enterpriseGatekeeperClientRetryPolicy().build();
        return (HttpResponseWithHeader)this.withStopConditionExceptionHandling(() -> (HttpResponseWithHeader)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callGsonWithResponseHeader(request, bodyType)));
    }

    private <T> T withStopConditionExceptionHandling(CheckedSupplier<T> supplier) {
        try {
            StopConditionCheckingUtil.throwIfStopConditionWasReached();
            return (T)supplier.get();
        }
        catch (FailsafeException e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                throw new UncheckedInterruptedException(e);
            }
            throw new FailsafeException((Throwable)e);
        }
        catch (UncheckedInterruptedException | InterruptedException e) {
            throw new UncheckedInterruptedException(e);
        }
        catch (Throwable e) {
            if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                throw new UncheckedInterruptedException(e);
            }
            throw new RuntimeException(e);
        }
    }

    public void sendMigrationStatusToMCS(String migrationId, String cloudId, MigrationStatus migrationStatus, String statusMessage) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("status", (Object)migrationStatus);
        body.put("statusMessage", statusMessage);
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(STATUS_PATH).toUriString()).put(RequestBody.create((String)Jsons.valueAsString(body), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetriesForSendingMCSStatus(request);
    }

    public void uploadFileToMCSSinglePart(String uploadUrl, File file, Tracker ... trackers) {
        String contentDisposition = "attachment; filename*=UTF-8''" + file.getName();
        Request request = new Request.Builder().addHeader("Content-Disposition", contentDisposition).url(uploadUrl).put(RequestBody.create((File)file, (MediaType)MediaTypes.APPLICATION_STREAM_TYPE)).build();
        this.callWithRetries(request);
        if (trackers.length > 0) {
            trackers[0].track(file.length());
        }
    }

    public Set<Space> getAllSpaces(CloudSite cloudSite) {
        HashSet<Space> spaceResults = new HashSet<Space>();
        String cloudId = cloudSite.getCloudId();
        String containerToken = cloudSite.getContainerToken();
        int pageNum = 1;
        int start = 0;
        while (true) {
            UriComponentsBuilder uriBuilder = this.getConfluenceUriBuilder(V1).pathSegment(new String[]{CLOUD_ID, cloudId, SPACE_PATH}).queryParam(CONFLUENCE_LIMIT_QUERY_PARAM, new Object[]{1000}).queryParam(CONFLUENCE_START_QUERY_PARAM, new Object[]{start});
            Request request = this.getJsonBuilder(cloudId, containerToken).url(uriBuilder.toUriString()).get().build();
            SpaceResponse spaceResult = this.callJsonWithRetries(request, new TypeReference<SpaceResponse>(){});
            spaceResults.addAll(spaceResult.results);
            log.debug("FetchAllCloudSpaces: Fetched page [" + pageNum + " ], results = " + spaceResult.size);
            ++pageNum;
            if (spaceResult.size < 1000) break;
            start += 1000;
        }
        return spaceResults;
    }

    public Map<String, Boolean> checkCalendarPresenceOnCloud(CloudSite cloudSite, List<String> calendarIds) {
        log.info("Checking presence of {} team calendars on cloud", (Object)calendarIds.size());
        String cloudId = cloudSite.getCloudId();
        String containerToken = cloudSite.getContainerToken();
        Map<String, Boolean> calendarsPresenceMap = new HashMap<String, Boolean>();
        UriComponentsBuilder uriBuilder = this.getConfluenceUriBuilder(V2).pathSegment(new String[]{CLOUD_ID, cloudId}).path("team-calendars/presence");
        Request request = this.getJsonBuilder(cloudId, containerToken).url(uriBuilder.toUriString()).post(RequestBody.create((String)Jsons.valueAsString(Collections.singletonMap("calendarIds", calendarIds)), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        try {
            TeamCalendarPresenceResponse response = this.callJsonWithRetries(request, new TypeReference<TeamCalendarPresenceResponse>(){});
            calendarsPresenceMap = response.getResults();
            log.info("Fetched presence of {} team calendars out of which {} calendars are already present on cloud", (Object)calendarsPresenceMap.size(), (Object)calendarsPresenceMap.values().stream().filter(v -> v == Boolean.TRUE).count());
        }
        catch (Exception e) {
            log.warn("Failed to check presence of {} team calendars, migrating all calendars...", (Object)calendarIds.size(), (Object)e);
        }
        return calendarsPresenceMap;
    }

    public List<CloudPageTemplate> getAllNonSpaceTemplates(String cloudId) {
        return this.getAllPagedResultsFromCloud(cloudId, 200, V1, PAGE_TEMPLATES_PATH, new TypeReference<PagedResponse<CloudPageTemplate>>(){});
    }

    private <R> List<R> getAllPagedResultsFromCloud(String cloudId, int batchSize, String version, String path, TypeReference<PagedResponse<R>> responseType) {
        ArrayList<R> results = new ArrayList<R>();
        int pageNum = 1;
        int start = 0;
        while (true) {
            List<R> currentPageResults = this.getPagedResultsFromCloud(cloudId, start, batchSize, version, path, responseType);
            results.addAll(currentPageResults);
            log.info("FetchType: {}, Fetched page [{}], resultSize = {}", new Object[]{responseType, pageNum, currentPageResults.size()});
            if (currentPageResults.size() < batchSize) break;
            start += batchSize;
            ++pageNum;
        }
        return results;
    }

    private <R> List<R> getPagedResultsFromCloud(String cloudId, int start, int limit, String version, String path, TypeReference<PagedResponse<R>> responseType) {
        UriComponentsBuilder uriBuilder = this.getConfluenceUriBuilder(version).pathSegment(new String[]{CLOUD_ID, cloudId}).path(path).queryParam(CONFLUENCE_START_QUERY_PARAM, new Object[]{start}).queryParam(CONFLUENCE_LIMIT_QUERY_PARAM, new Object[]{limit});
        Request request = this.getJsonBuilder(cloudId).url(uriBuilder.toUriString()).get().build();
        PagedResponse<R> response = this.callJsonWithRetries(request, responseType);
        return response.getResults();
    }

    public List<EntityActionDTO> sendServerInstanceInfoToMigrationMetadataAggregator(String containerToken, String cloudId, MetadataBatch<ServerInstanceDTO> batchServerInstanceDTO) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(MIGRATION_METADATA_AGGREGATOR_SERVER_PATH).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)this.gson.toJson(batchServerInstanceDTO))).build();
        JsonArray jsonArray = this.callGsonWithRetries(request, JsonArray.class);
        ArrayList<EntityActionDTO> resultList = new ArrayList<EntityActionDTO>();
        jsonArray.forEach(element -> {
            EntityActionDTO action = (EntityActionDTO)this.gson.fromJson(element, EntityActionDTO.class);
            resultList.add(action);
        });
        return resultList;
    }

    public JsonElement sendSpaceMetadataToMigrationMetadataAggregator(String containerToken, String cloudId, MetadataBatch<SpaceMetadataDTO> spaceMetaData) {
        String jsonifiedSpaceMetadata = new GsonBuilder().setDateFormat(MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT).create().toJson(spaceMetaData);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_PATH).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)jsonifiedSpaceMetadata)).build();
        return this.callGsonWithRetries(request, JsonElement.class);
    }

    public JsonElement sendUserMetadataToMigrationMetadataAggregator(String containerToken, String cloudId, MetadataBatch<SpaceMetadataDTO> spaceMetaData) {
        String jsonifiedSpaceMetadata = new GsonBuilder().setDateFormat(MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT).create().toJson(spaceMetaData);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(MIGRATION_METADATA_AGGREGATOR_USER_METADATA_PATH).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)jsonifiedSpaceMetadata)).build();
        return this.callGsonWithRetries(request, JsonElement.class);
    }

    public JsonElement sendAppMetadataToMigrationMetadataAggregator(String containerToken, String cloudId, MetadataBatch<AppMetadata> appMetadata) {
        String jsonifiedAppMetadata = new GsonBuilder().setDateFormat(MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT).create().toJson(appMetadata);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(MIGRATION_METADATA_AGGREGATOR_APPS_METADATA_PATH).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)jsonifiedAppMetadata)).build();
        return this.callGsonWithRetries(request, JsonElement.class);
    }

    public JsonElement sendDomainMetadataToMigrationMetadataAggregator(String containerToken, String cloudId, MetadataBatch<DomainMetadataDTO> domainMetadata) {
        String jsonifiedAppMetadata = new GsonBuilder().setDateFormat(MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT).create().toJson(domainMetadata);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(MIGRATION_METADATA_AGGREGATOR_DOMAINS_METADATA_PATH).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)jsonifiedAppMetadata)).build();
        return this.callGsonWithRetries(request, JsonElement.class);
    }

    public JsonElement sendRefreshStatusUpdtateToMigrationMetadataAggregatorForSingleEntity(String containerToken, String cloudId, String serverId, MetadataRefreshState refreshState) {
        String jsonifiedRefreshState = new GsonBuilder().setDateFormat(MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT).create().toJson((Object)refreshState);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(String.format(MIGRATION_METADATA_AGGREGATOR_STATUS_UPDATE_PATH, cloudId, serverId)).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)jsonifiedRefreshState)).build();
        return this.callGsonWithRetries(request, JsonElement.class);
    }

    public void sendSpaceMetadataToMigrationMetadataAggregatorForSingleEntity(String containerToken, String cloudId, String serverId, SpaceMetadataDTO spaceMetaData) {
        String jsonifiedSpaceMetadata = new GsonBuilder().setDateFormat(MIGRATION_METADATA_AGGREGATOR_EXPECTED_DATE_FORMAT).create().toJson((Object)spaceMetaData);
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(String.format(MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_SINGLE_ENTITY_PATH, cloudId, serverId)).toUriString()).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)jsonifiedSpaceMetadata)).build();
        this.callGsonWithRetries(request, JsonElement.class);
    }

    public void deleteSpaceMetadataFromMigrationMetadataAggregator(String containerToken, String cloudId, String serverId) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).queryParam(MIGRATION_METADATA_AGGREGATOR_SERVER_ID_QUERY_PARAM, new Object[]{serverId}).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).path(MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_PATH).toUriString()).delete().build();
        this.callGsonWithRetries(request, JsonElement.class);
    }

    public void deleteAppMetadataFromMigrationMetadataAggregator(String containerToken, String cloudId, String serverId) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).queryParam(MIGRATION_METADATA_AGGREGATOR_SERVER_ID_QUERY_PARAM, new Object[]{serverId}).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).path(MIGRATION_METADATA_AGGREGATOR_APPS_METADATA_PATH).toUriString()).delete().build();
        this.callGsonWithRetries(request, JsonElement.class);
    }

    public void deleteDomainMetadataFromMigrationMetadataAggregator(String containerToken, String cloudId, String serverId) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).queryParam(MIGRATION_METADATA_AGGREGATOR_SERVER_ID_QUERY_PARAM, new Object[]{serverId}).queryParam(MIGRATION_METADATA_AGGREGATOR_CLOUD_ID_QUERY_PARAM, new Object[]{cloudId}).path(MIGRATION_METADATA_AGGREGATOR_DOMAINS_METADATA_PATH).toUriString()).delete().build();
        this.callGsonWithRetries(request, JsonElement.class);
    }

    TransferResponseList createTransfers(String cloudId, String migrationId, String containerId, List<String> operationKeys) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(CONTAINER_PATH).pathSegment(new String[]{containerId}).path(TRANSFER_PATH).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(operationKeys), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return this.callJsonWithRetries(request, new TypeReference<TransferResponseList>(){});
    }

    void updateTransferProgress(String cloudId, String migrationId, String transferId, TransferProgressRequest transferProgressRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(TRANSFER_PATH).pathSegment(new String[]{transferId}).path(PROGRESS_PATH).toUriString()).put(RequestBody.create((String)Jsons.valueAsString(transferProgressRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetries(request);
    }

    void updateTransferStatus(String cloudId, String migrationId, String transferId, TransferStatus migrationStatus, @Nullable String statusMessage) {
        TransferStatusUpdateRequest transferStatusUpdateRequest = new TransferStatusUpdateRequest(migrationStatus, statusMessage);
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(TRANSFER_PATH).pathSegment(new String[]{transferId}).path(STATUS_PATH).toUriString()).put(RequestBody.create((String)this.gson.toJson((Object)transferStatusUpdateRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetriesForSendingMCSStatus(request);
    }

    void updateTransferStatus(String cloudId, String migrationId, String transferId, TransferStatusesUpdateRequest transferStatusesUpdateRequest) {
        Request request = this.getJsonBuilder(cloudId).url(this.getUriBuilder(V1).path(MIGRATION_PATH).pathSegment(new String[]{migrationId}).path(TRANSFER_PATH).pathSegment(new String[]{transferId}).path(STATUS_PATH).toUriString()).put(RequestBody.create((String)this.gson.toJson((Object)transferStatusesUpdateRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetriesForSendingMCSStatus(request);
    }

    public void sendMapiTaskStatus(String jobId, String taskId, String cloudId, String containerToken, List<MapiStatusDto> mapiStatusDtoList) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMapiUriBuilder(V1).path(MAPI_PATH).pathSegment(new String[]{jobId}).pathSegment(new String[]{"tasks", taskId}).path("status").toUriString()).post(RequestBody.create((String)Jsons.valueAsString(mapiStatusDtoList), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        this.callWithRetries(request);
    }

    public void deleteSpaceMetadataFromMigrationMetadataAggregator(String containerToken, String cloudId, String serverId, long spaceId) {
        Request request = this.getJsonBuilder(cloudId, containerToken).url(this.getMigrationMetadataAggregatorUriBuilder(V1).path(String.format(MIGRATION_METADATA_AGGREGATOR_SPACE_METADATA_DELETE_PATH, cloudId, serverId, spaceId)).toUriString()).delete().build();
        this.callGsonWithRetries(request, JsonElement.class, (Set<Integer>)ImmutableSet.of((Object)HttpStatus.BAD_REQUEST.value()));
    }

    public ArtifactResponse sendErrorLogsArtifactsToMapi(ErrorLogsArtifactRequest errorLogsArtifactRequest) {
        Request request = this.getJsonBuilder(errorLogsArtifactRequest.getCloudId(), errorLogsArtifactRequest.getContainerToken()).url(this.getMapiUriBuilder(V1).path(MAPI_PATH).pathSegment(new String[]{errorLogsArtifactRequest.getJobId()}).pathSegment(new String[]{"tasks", errorLogsArtifactRequest.getTaskId()}).path("artifacts").toUriString()).put(RequestBody.create((String)Jsons.valueAsString(errorLogsArtifactRequest.getArtifactRequest()), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return (ArtifactResponse)this.gson.fromJson(this.callGsonWithRetries(request, JsonElement.class), ArtifactResponse.class);
    }

    public CreateContainerTokenResponse createContainerToken(CreateContainerTokenRequest tokenRequest, String containerToken) {
        Request request = this.getJsonBuilderWithContainerToken(containerToken).url(this.getMapiUriBuilder(V1).path(MAPI_TOKEN_PATH).toUriString()).post(RequestBody.create((String)Jsons.valueAsString(tokenRequest), (MediaType)MediaTypes.APPLICATION_JSON_TYPE)).build();
        return (CreateContainerTokenResponse)this.gson.fromJson(this.callGsonWithRetries(request, JsonElement.class), CreateContainerTokenResponse.class);
    }

    public DataMovementRegisterResponse registerDataMovement(Plan plan, DataMovementRegisterRequest.DataMovementMetadata dataMovementMetadata) {
        DataMovementRegisterRequest dataMovementRegisterRequest = DataMovementRegisterRequest.builder().destination(DataMovementRegisterRequest.Destination.builder().siteInfo(DataMovementRegisterRequest.Destination.SiteInfo.builder().cloudId(plan.getCloudSite().getCloudId()).build()).build()).scaleUpResources(Boolean.TRUE).migrationPhase(plan.getMigrationTag()).dataMovementMetaData(dataMovementMetadata).build();
        String uri = this.getConfluenceUriBuilder(V1).path(String.format(DATA_MOVEMENT_REGISTER_API, plan.getMigrationId())).toUriString();
        log.info("Data Movement Register Request {}, {}", (Object)dataMovementRegisterRequest, (Object)uri);
        Request request = this.getJsonBuilderWithContainerToken(plan.getCloudSite().getContainerToken()).url(uri).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(dataMovementRegisterRequest))).build();
        return this.httpService.callJson(request, new TypeReference<DataMovementRegisterResponse>(){});
    }

    public DataMovementUpdateResponse updateDataMovement(Plan plan) {
        String containerToken = plan.getCloudSite().getContainerToken();
        String dataMovementId = plan.getDataMovementId();
        String migrationId = plan.getMigrationId();
        ExecutionStatus executionStatus = plan.getProgress().getStatus();
        String uri = this.getConfluenceUriBuilder(V1).path(String.format(DATA_MOVEMENT_UPDATE_API, migrationId, dataMovementId)).toUriString();
        DataMovementUpdateRequest dataMovementUpdateRequest = new DataMovementUpdateRequest(executionStatus);
        log.info("Data Movement Update Request {}, {}", (Object)dataMovementUpdateRequest, (Object)uri);
        Request request = this.getJsonBuilderWithContainerToken(containerToken).url(uri).post(RequestBody.create((MediaType)MediaTypes.APPLICATION_JSON_TYPE, (String)Jsons.valueAsString(dataMovementUpdateRequest))).build();
        return this.callJsonWithRetries(request, new TypeReference<DataMovementUpdateResponse>(){});
    }

    public ResourceOptimisationStatusResponse getResourceOptimisationStatus(String containerToken, String migrationId, String dataMovementId) {
        String uri = this.getConfluenceUriBuilder(V1).path(String.format(GET_RESOURCE_OPTIMISATION_STATUS_API, migrationId, dataMovementId)).toUriString();
        log.info("Data Movement - Resource Optimisation Status - {}", (Object)uri);
        Request request = this.getJsonBuilderWithContainerToken(containerToken).addHeader("Content-Type", "application/json").url(uri).get().build();
        return this.callJsonWithRetries(request, new TypeReference<ResourceOptimisationStatusResponse>(){});
    }
}

