/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.web;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.migration.agent.rest.GenerateCloudSiteSetupUrlDto;
import com.atlassian.migration.agent.service.cloud.ContainerTokenService;
import com.atlassian.migration.agent.service.cloud.NonceService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.PermittedMethods;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class SaveCloudSiteAction
extends ConfluenceActionSupport {
    private static final String NONCE_ERROR_CODE = "nonceError-";
    private static final String AUTH_ERROR_CODE = "authError-";
    private static final String SUCCESS = "success-";
    private static final String CLOUD_CONNECT_ERROR_CODE = "cloudConnectError-";
    private String cloudUrl;
    private String cloudId;
    private String containerToken;
    private String nonce;
    private String cloudEdition;
    private String redirectTo;
    private String planId;
    private String cloudType;
    private String cloudOrigin;
    private final transient NonceService nonceService;
    private final ContainerTokenService containerTokenService;

    SaveCloudSiteAction(NonceService nonceService, ContainerTokenService containerTokenService) {
        this.nonceService = nonceService;
        this.containerTokenService = containerTokenService;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        if (Stream.of(this.cloudUrl, this.cloudId, this.containerToken, this.nonce, this.redirectTo, this.cloudType).anyMatch(Objects::isNull)) {
            return AUTH_ERROR_CODE + this.redirectOrDefault(this.redirectTo);
        }
        if (!this.nonceService.validateAndDeleteNonce(this.nonce)) {
            return NONCE_ERROR_CODE + this.redirectTo;
        }
        Optional<Edition> edition = Optional.ofNullable(this.cloudEdition).map(s -> Edition.getByKey((String)this.cloudEdition));
        boolean redirectWithoutError = this.containerTokenService.saveToken(this.cloudUrl, this.cloudId, edition, this.cloudType, this.containerToken, this.cloudOrigin);
        if (redirectWithoutError) {
            return SUCCESS + this.redirectOrDefault(this.redirectTo);
        }
        return CLOUD_CONNECT_ERROR_CODE + this.redirectOrDefault(this.redirectTo);
    }

    private String redirectOrDefault(String redirectTo) {
        return StringUtils.isNotEmpty((CharSequence)redirectTo) ? redirectTo : GenerateCloudSiteSetupUrlDto.DEFAULT_REDIRECT;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public String getCloudOrigin() {
        return this.cloudOrigin;
    }

    @ParameterSafe
    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @ParameterSafe
    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    @ParameterSafe
    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    @ParameterSafe
    public void setContainerToken(String containerToken) {
        this.containerToken = containerToken;
    }

    @ParameterSafe
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @ParameterSafe
    public void setCloudEdition(String cloudEdition) {
        this.cloudEdition = cloudEdition;
    }

    @ParameterSafe
    public void setRedirectTo(String redirectTo) {
        this.redirectTo = redirectTo;
    }

    @ParameterSafe
    public void setCloudType(String cloudType) {
        this.cloudType = cloudType;
    }

    @ParameterSafe
    public void setCloudOrigin(String cloudOrigin) {
        this.cloudOrigin = cloudOrigin;
    }

    public String getCloudType() {
        return this.cloudType;
    }
}

