/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails;

import com.atlassian.migration.agent.store.guardrails.InstanceAssessmentStatus;
import java.time.Instant;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class AssessmentStatus {
    @Nullable
    private final Instant finishDate;
    @Nullable
    private final Instant completedDate;
    private final InstanceAssessmentStatus status;
    @Nullable
    private final String description;
    @Nullable
    private final String progress;
    @Nullable
    private final Long remainingDuration;
    @Nullable
    private final Long percentage;

    private AssessmentStatus(@Nullable Instant finishDate, @Nullable Instant completedDate, InstanceAssessmentStatus status, @Nullable String progress, @Nullable String description, @Nullable Long remainingDuration, @Nullable Long percentage) {
        this.finishDate = finishDate;
        this.completedDate = completedDate;
        this.status = status;
        this.progress = progress;
        this.description = description;
        this.remainingDuration = remainingDuration;
        this.percentage = percentage;
    }

    private AssessmentStatus(InstanceAssessmentStatus status) {
        this(null, null, status, null, null, null, null);
    }

    public static AssessmentStatus newAssessment() {
        return new AssessmentStatus(InstanceAssessmentStatus.NEW);
    }

    public static AssessmentStatus inProgressAssessment(String description) {
        return new AssessmentStatus(null, null, InstanceAssessmentStatus.IN_PROGRESS, null, description, null, null);
    }

    public static AssessmentStatus inProgressAssessment(Long remainingDurationMs, Long percentage, String description) {
        return new AssessmentStatus(null, null, InstanceAssessmentStatus.IN_PROGRESS, null, description, remainingDurationMs, percentage);
    }

    public static AssessmentStatus inProgressAssessmentOld(String progress) {
        return new AssessmentStatus(null, null, InstanceAssessmentStatus.IN_PROGRESS, progress, null, null, null);
    }

    public static AssessmentStatus completedAssessmentOld(Instant completedDate) {
        return new AssessmentStatus(null, completedDate, InstanceAssessmentStatus.COMPLETE, "100% COMPLETE", null, null, null);
    }

    public static AssessmentStatus completedAssessment(Instant finishDate) {
        return new AssessmentStatus(finishDate, null, InstanceAssessmentStatus.COMPLETE, null, null, null, null);
    }

    public static AssessmentStatus cancelAssessment(Instant cancelDate) {
        return new AssessmentStatus(cancelDate, null, InstanceAssessmentStatus.CANCELED, null, "Assessment canceled", null, null);
    }

    public static AssessmentStatus notStartedAssessment() {
        return new AssessmentStatus(InstanceAssessmentStatus.NOT_STARTED);
    }

    public static AssessmentStatus failedAssessment() {
        return new AssessmentStatus(InstanceAssessmentStatus.FAILED);
    }

    public static AssessmentStatus failedAssessment(Instant finishDate) {
        return new AssessmentStatus(finishDate, null, InstanceAssessmentStatus.FAILED, null, null, null, null);
    }

    @Nullable
    @Generated
    public Instant getFinishDate() {
        return this.finishDate;
    }

    @Nullable
    @Generated
    public Instant getCompletedDate() {
        return this.completedDate;
    }

    @Generated
    public InstanceAssessmentStatus getStatus() {
        return this.status;
    }

    @Nullable
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Nullable
    @Generated
    public String getProgress() {
        return this.progress;
    }

    @Nullable
    @Generated
    public Long getRemainingDuration() {
        return this.remainingDuration;
    }

    @Nullable
    @Generated
    public Long getPercentage() {
        return this.percentage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssessmentStatus)) {
            return false;
        }
        AssessmentStatus other = (AssessmentStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$remainingDuration = this.getRemainingDuration();
        Long other$remainingDuration = other.getRemainingDuration();
        if (this$remainingDuration == null ? other$remainingDuration != null : !((Object)this$remainingDuration).equals(other$remainingDuration)) {
            return false;
        }
        Long this$percentage = this.getPercentage();
        Long other$percentage = other.getPercentage();
        if (this$percentage == null ? other$percentage != null : !((Object)this$percentage).equals(other$percentage)) {
            return false;
        }
        Instant this$finishDate = this.getFinishDate();
        Instant other$finishDate = other.getFinishDate();
        if (this$finishDate == null ? other$finishDate != null : !((Object)this$finishDate).equals(other$finishDate)) {
            return false;
        }
        Instant this$completedDate = this.getCompletedDate();
        Instant other$completedDate = other.getCompletedDate();
        if (this$completedDate == null ? other$completedDate != null : !((Object)this$completedDate).equals(other$completedDate)) {
            return false;
        }
        InstanceAssessmentStatus this$status = this.getStatus();
        InstanceAssessmentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$progress = this.getProgress();
        String other$progress = other.getProgress();
        return !(this$progress == null ? other$progress != null : !this$progress.equals(other$progress));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssessmentStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $remainingDuration = this.getRemainingDuration();
        result = result * 59 + ($remainingDuration == null ? 43 : ((Object)$remainingDuration).hashCode());
        Long $percentage = this.getPercentage();
        result = result * 59 + ($percentage == null ? 43 : ((Object)$percentage).hashCode());
        Instant $finishDate = this.getFinishDate();
        result = result * 59 + ($finishDate == null ? 43 : ((Object)$finishDate).hashCode());
        Instant $completedDate = this.getCompletedDate();
        result = result * 59 + ($completedDate == null ? 43 : ((Object)$completedDate).hashCode());
        InstanceAssessmentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : $progress.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssessmentStatus(finishDate=" + this.getFinishDate() + ", completedDate=" + this.getCompletedDate() + ", status=" + (Object)((Object)this.getStatus()) + ", description=" + this.getDescription() + ", progress=" + this.getProgress() + ", remainingDuration=" + this.getRemainingDuration() + ", percentage=" + this.getPercentage() + ")";
    }
}

