/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.impl;

import com.atlassian.migration.agent.model.CsvReadResult;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CsvReaderService.class);

    public CSVReader getCsvReaderForInputStream(InputStream inputStream) {
        return new CSVReader((Reader)new InputStreamReader(inputStream));
    }

    public CSVReader getCsvReaderForInputStreamWithDelimiter(InputStream inputStream, char delimiter) {
        if (delimiter == ',') {
            CSVParser csvParser = new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').build();
            return new CSVReaderBuilder((Reader)new InputStreamReader(inputStream)).withCSVParser((ICSVParser)csvParser).build();
        }
        if (delimiter == ';') {
            CSVParser csvParser = new CSVParserBuilder().withSeparator(';').withQuoteChar('\"').build();
            return new CSVReaderBuilder((Reader)new InputStreamReader(inputStream)).withCSVParser((ICSVParser)csvParser).build();
        }
        if (delimiter == '\t') {
            CSVParser csvParser = new CSVParserBuilder().withSeparator('\t').withQuoteChar('\"').build();
            return new CSVReaderBuilder((Reader)new InputStreamReader(inputStream)).withCSVParser((ICSVParser)csvParser).build();
        }
        CSVParser csvParser = new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').build();
        return new CSVReaderBuilder((Reader)new InputStreamReader(inputStream)).withCSVParser((ICSVParser)csvParser).build();
    }

    public <T> CsvReadResult<T> readCsvLine(Reader reader, Class<T> resultClass) throws IOException {
        List resultList;
        String errorMessage = null;
        try (CSVReader csvReader = new CSVReader(reader);){
            CsvToBean csvToBean = new CsvToBeanBuilder(csvReader).withType(resultClass).build();
            resultList = csvToBean.parse();
        }
        catch (Exception e) {
            errorMessage = String.format("Failed to read CSV file: %s", e.getMessage());
            resultList = null;
        }
        return new CsvReadResult<Object>((resultList != null && !resultList.isEmpty() ? (Object)resultList.get(0) : null), errorMessage);
    }
}

