/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.dto.ProductDto;
import com.atlassian.migration.agent.service.impl.SENSupplier;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMetadataCollector {
    private final Logger log = LoggerFactory.getLogger(InstanceMetadataCollector.class);
    private final DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final SENSupplier senSupplier;
    private final SystemInformationService systemInformationService;
    private final LicenseHandler licenseHandler;
    private final TimeZoneManager timeZoneManager;

    public InstanceMetadataCollector(SENSupplier senSupplier, SystemInformationService systemInformationService, LicenseHandler licenseHandler, TimeZoneManager timeZoneManager) {
        this.senSupplier = senSupplier;
        this.systemInformationService = systemInformationService;
        this.licenseHandler = licenseHandler;
        this.timeZoneManager = timeZoneManager;
    }

    public InstanceMetadataDto collectMetadata(Instant start) {
        this.log.info("Collecting Instance metadata.");
        String serverID = this.licenseHandler.getServerId();
        TimeZone timeZone = this.timeZoneManager.getDefaultTimeZone();
        String offsetHours = this.getOffsetInHours(timeZone);
        String gmtString = this.createGMTString(offsetHours);
        String startDateTime = LocalDateTime.ofInstant(start, timeZone.toZoneId()).format(this.dateTimeFormat);
        String sen = "";
        if (this.senSupplier.get() != null) {
            sen = this.senSupplier.get();
        }
        this.log.info("Instance metadata collected.");
        return new InstanceMetadataDto(new ProductDto("Confluence", this.systemInformationService.getConfluenceInfo().getVersion()), sen, serverID, gmtString, startDateTime, this.systemInformationService.getConfluenceInfo().getBaseUrl());
    }

    private String getOffsetInHours(TimeZone timeZone) {
        int offset = timeZone.getRawOffset();
        return Integer.toString(offset / 1000 / 60 / 60);
    }

    private String createGMTString(String offset) {
        return String.format("GMT%s%s", offset.startsWith("-") ? "" : "+", offset);
    }
}

