/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.analytics;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.migration.agent.service.analytics.AppsPreflightAnalyticsEventParams;
import com.atlassian.migration.agent.service.analytics.PreflightAnalyticsEventParams;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

public class AnalyticsEventParams {
    private final Instant startTime;
    private final CheckResult checkResult;
    private final long totalTime;
    private final String executionId;
    private final String resultState;
    private final UUID uniqueId;

    public AnalyticsEventParams(Instant startTime, CheckResult checkResult, String executionId, String resultState, UUID uniqueId) {
        assert (startTime != null);
        this.startTime = startTime;
        this.checkResult = checkResult;
        this.executionId = executionId;
        this.resultState = resultState;
        this.uniqueId = uniqueId;
        this.totalTime = Duration.between(startTime, Instant.now()).toMillis();
    }

    public PreflightAnalyticsEventParams toPreflightAnalyticsEventParams() {
        return new PreflightAnalyticsEventParams(this.checkResult, this.totalTime, this.executionId, this.uniqueId);
    }

    public AppsPreflightAnalyticsEventParams toAppsPreflightAnalyticsEventParams() {
        return new AppsPreflightAnalyticsEventParams(this.checkResult, this.totalTime, this.executionId, this.uniqueId);
    }

    @Generated
    public static AnalyticsEventParamsBuilder builder() {
        return new AnalyticsEventParamsBuilder();
    }

    @Generated
    public Instant getStartTime() {
        return this.startTime;
    }

    @Generated
    public CheckResult getCheckResult() {
        return this.checkResult;
    }

    @Generated
    public long getTotalTime() {
        return this.totalTime;
    }

    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public String getResultState() {
        return this.resultState;
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public static class AnalyticsEventParamsBuilder {
        @Generated
        private Instant startTime;
        @Generated
        private CheckResult checkResult;
        @Generated
        private String executionId;
        @Generated
        private String resultState;
        @Generated
        private UUID uniqueId;

        @Generated
        AnalyticsEventParamsBuilder() {
        }

        @Generated
        public AnalyticsEventParamsBuilder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public AnalyticsEventParamsBuilder checkResult(CheckResult checkResult) {
            this.checkResult = checkResult;
            return this;
        }

        @Generated
        public AnalyticsEventParamsBuilder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public AnalyticsEventParamsBuilder resultState(String resultState) {
            this.resultState = resultState;
            return this;
        }

        @Generated
        public AnalyticsEventParamsBuilder uniqueId(UUID uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        @Generated
        public AnalyticsEventParams build() {
            return new AnalyticsEventParams(this.startTime, this.checkResult, this.executionId, this.resultState, this.uniqueId);
        }

        @Generated
        public String toString() {
            return "AnalyticsEventParams.AnalyticsEventParamsBuilder(startTime=" + this.startTime + ", checkResult=" + this.checkResult + ", executionId=" + this.executionId + ", resultState=" + this.resultState + ", uniqueId=" + this.uniqueId + ")";
        }
    }
}

