/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.planning;

import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.impl.StepTypeEnum;
import com.atlassian.migration.agent.service.planning.StepPlanningEngine;
import com.atlassian.migration.agent.v4.MigrationProtocol;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public abstract class BaseStepPlanningEngine<T extends Task>
implements StepPlanningEngine<T> {
    private final Class<T> taskType;
    private final Map<String, StepPlanningEngine.PercentRange> v2PercentRangeMap;
    private final Map<String, StepPlanningEngine.PercentRange> v4PercentRangeMap;
    private static final Logger log = ContextLoggerFactory.getLogger(BaseStepPlanningEngine.class);
    private final Map<String, Map<String, StepPlanningEngine.PercentRange>> v2SubStepPercentageRangeMap;
    private final Map<String, Map<String, StepPlanningEngine.PercentRange>> v4SubStepPercentageRangeMap;

    BaseStepPlanningEngine(Class<T> taskType, Collection<Pair<StepTypeEnum, Integer>> v2PercentAtEnd, Collection<Pair<StepTypeEnum, Integer>> v4PercentAtEnd, Collection<Pair<StepType, Collection<Pair<StepTypeEnum, Integer>>>> v2SubStepPercentageRangeAtEnd, Collection<Pair<StepType, Collection<Pair<StepTypeEnum, Integer>>>> v4SubStepPercentageRangeAtEnd) {
        this.taskType = taskType;
        this.v2PercentRangeMap = BaseStepPlanningEngine.calculateStepPercentRangeMap(v2PercentAtEnd);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Pair<StepType, Collection<Pair<StepTypeEnum, Integer>>> entry : v2SubStepPercentageRangeAtEnd) {
            builder.put((Object)((StepType)entry.getKey()).name(), BaseStepPlanningEngine.calculateStepPercentRangeMap((Collection)entry.getValue()));
        }
        this.v2SubStepPercentageRangeMap = builder.build();
        this.v4PercentRangeMap = BaseStepPlanningEngine.calculateStepPercentRangeMap(v4PercentAtEnd);
        ImmutableMap.Builder v4Builder = ImmutableMap.builder();
        for (Pair<StepType, Collection<Pair<StepTypeEnum, Integer>>> entry : v4SubStepPercentageRangeAtEnd) {
            v4Builder.put((Object)((StepType)entry.getKey()).name(), BaseStepPlanningEngine.calculateStepPercentRangeMap((Collection)entry.getValue()));
        }
        this.v4SubStepPercentageRangeMap = v4Builder.build();
    }

    BaseStepPlanningEngine(Class<T> taskType, Collection<Pair<StepTypeEnum, Integer>> v2PercentAtEnd, Collection<Pair<StepTypeEnum, Integer>> v4PercentAtEnd) {
        this(taskType, v2PercentAtEnd, v4PercentAtEnd, Collections.emptyList(), Collections.emptyList());
    }

    BaseStepPlanningEngine(Class<T> taskType, Collection<Pair<StepTypeEnum, Integer>> percentAtEnd) {
        this(taskType, percentAtEnd, percentAtEnd, Collections.emptyList(), Collections.emptyList());
    }

    private static Map<String, StepPlanningEngine.PercentRange> calculateStepPercentRangeMap(Collection<Pair<StepTypeEnum, Integer>> percentAtEnd) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int currentPercent = 0;
        for (Pair<StepTypeEnum, Integer> entry : percentAtEnd) {
            int to;
            int from = currentPercent;
            currentPercent = to = currentPercent + (Integer)entry.getRight();
            builder.put((Object)((StepTypeEnum)entry.getLeft()).name(), (Object)new StepPlanningEngine.PercentRange(from, to));
        }
        if (currentPercent != 100) {
            throw new IllegalArgumentException("Sum of all steps' percentages should be 100, current value " + currentPercent);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Optional<StepPlanningEngine.PercentRange> getStepPercentRange(Step step) {
        Map<String, StepPlanningEngine.PercentRange> currentPercentRangeMap = this.currentPercentRangeMap(step);
        return Optional.ofNullable(currentPercentRangeMap.get(step.getType()));
    }

    private Map<String, StepPlanningEngine.PercentRange> currentPercentRangeMap(Step step) {
        if (MigrationProtocol.V4.equals((Object)step.getPlan().getMigrationProtocol())) {
            return this.v4PercentRangeMap;
        }
        return this.v2PercentRangeMap;
    }

    private Map<String, Map<String, StepPlanningEngine.PercentRange>> currentSubStepPercentRangeMap(Step step) {
        if (MigrationProtocol.V4.equals((Object)step.getPlan().getMigrationProtocol())) {
            return this.v4SubStepPercentageRangeMap;
        }
        return this.v2SubStepPercentageRangeMap;
    }

    @Override
    @Nonnull
    public Optional<StepPlanningEngine.PercentRange> getSubStepPercentRange(Step step) {
        Map<String, Map<String, StepPlanningEngine.PercentRange>> currentSubStepPercentRangeMap = this.currentSubStepPercentRangeMap(step);
        Map<String, StepPlanningEngine.PercentRange> currentPercentRangeMap = this.currentPercentRangeMap(step);
        try {
            if (!currentSubStepPercentRangeMap.isEmpty()) {
                return Optional.ofNullable(currentSubStepPercentRangeMap.getOrDefault(step.getType(), Collections.emptyMap()).getOrDefault(step.getSubType(), null));
            }
            return Optional.ofNullable(currentPercentRangeMap.get(step.getSubType()));
        }
        catch (Exception e) {
            log.warn("Error reading sub step percentage for Step: {}", (Object)step.getType());
            return Optional.empty();
        }
    }

    @Override
    public Class<T> getTaskType() {
        return this.taskType;
    }
}

