/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.network;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.service.check.network.ConnectivityTester;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityHttpUrlConnectionTester
implements ConnectivityTester {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectivityHttpUrlConnectionTester.class);
    private OkHttpClient client;

    public ConnectivityHttpUrlConnectionTester(OKHttpProxyBuilder okHttpProxyBuilder) {
        this.client = ConnectivityHttpUrlConnectionTester.buildHttpClient(okHttpProxyBuilder);
    }

    @Override
    public boolean isReachable(String url) {
        try {
            URL siteUrl = this.getUrl(url);
            Request request = new Request.Builder().addHeader("Accept", "application/json").url(siteUrl).get().build();
            this.client.newCall(request).execute().close();
            return true;
        }
        catch (Exception e) {
            log.warn("Error during check connectivity for domain: {}", (Object)url, (Object)e);
            return false;
        }
    }

    @NotNull
    @VisibleForTesting
    URL getUrl(String url) throws MalformedURLException {
        return new URL(url);
    }

    private static OkHttpClient buildHttpClient(OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(3L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(10L, TimeUnit.SECONDS).build();
    }
}

