/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.listener;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.migration.agent.dto.AppListenerIssueType;
import com.atlassian.migration.agent.service.MigrationAppAggregatorResponse;
import com.atlassian.migration.agent.service.PreflightErrorCode;
import com.atlassian.migration.agent.service.app.AppListenerIssueService;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerContext;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerDto;
import com.atlassian.migration.agent.service.impl.AppAssessmentFacade;
import com.atlassian.migration.agent.service.impl.MigrationAppAggregatorService;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class AppListenerChecker
implements Checker<AppListenerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppListenerChecker.class);
    private static final String VIOLATIONS_KEY = "violations";
    private static final String SUCCESSES_KEY = "successes";
    private final AppListenerIssueService appListenerIssueService;
    private final MigrationAppAggregatorService migrationAppAggregatorService;
    private final AppAssessmentFacade appAssessmentFacade;

    public AppListenerChecker(AppListenerIssueService appListenerIssueService, MigrationAppAggregatorService migrationAppAggregatorService, AppAssessmentFacade appAssessmentFacade) {
        this.appListenerIssueService = appListenerIssueService;
        this.migrationAppAggregatorService = migrationAppAggregatorService;
        this.appAssessmentFacade = appAssessmentFacade;
    }

    public CheckResult check(AppListenerContext appListenerContext) {
        log.debug("Executing {} for appKeys {}", (Object)CheckType.APP_MISSING_LISTENER_CHECK, appListenerContext.appKeys);
        try {
            List<String> appKeys = appListenerContext.appKeys;
            Set<String> appsMissingListener = appKeys.stream().filter(appKey -> this.appListenerIssueService.determineIssue((String)appKey) == AppListenerIssueType.AUTOMATED_WITHOUT_SERVER_LISTENER).collect(Collectors.toSet());
            Set appsWithListener = appKeys.stream().filter(appKey -> !appsMissingListener.contains(appKey)).collect(Collectors.toSet());
            return new CheckResult(appsMissingListener.isEmpty(), (Map)ImmutableMap.of((Object)SUCCESSES_KEY, appsWithListener, (Object)VIOLATIONS_KEY, this.convertToDto(appsMissingListener)));
        }
        catch (Exception e) {
            log.error("Error executing apps missing listener check.", (Throwable)e);
            return new CheckResult(false, Collections.singletonMap("executionErrorDetails", PreflightErrorCode.GENERIC_ERROR.getCode()));
        }
    }

    private Set<AppListenerDto> convertToDto(Set<String> appsMissingListener) {
        return appsMissingListener.stream().map(appKey -> new AppListenerDto((String)appKey, this.getAppName((String)appKey))).collect(Collectors.toSet());
    }

    private String getAppName(String appKey) {
        MigrationAppAggregatorResponse cachedServerAppData = this.migrationAppAggregatorService.getCachedServerAppData(appKey);
        return this.appAssessmentFacade.getAppName(appKey, cachedServerAppData);
    }

    static Set<AppListenerDto> retrieveAppsMissingListeners(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS_KEY, Collections.emptySet());
    }

    static Set<String> retrieveAppsWithListeners(Map<String, Object> details) {
        return details.getOrDefault(SUCCESSES_KEY, Collections.emptySet());
    }
}

