/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.processors;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.StepResult;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceExportExecutor;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUsersMigrationExecutor;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.AbstractProcessor;
import com.atlassian.migration.agent.v4.tasks.SpaceExportTransferTask;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class SpaceExportProcessor
extends AbstractProcessor<SpaceExportTransferTask> {
    private final SpaceExportExecutor spaceExportExecutor;
    private final SpaceUsersMigrationExecutor spaceUsersMigrationExecutor;
    private final Step prcStep;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final StepStore stepStore;
    private final PluginTransactionTemplate ptx;
    private static final Logger log = ContextLoggerFactory.getLogger(SpaceExportProcessor.class);

    public SpaceExportProcessor(PrcTask<SpaceExportTransferTask> prcTask, Step prcStep, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, SpaceExportExecutor spaceExportExecutor, SpaceUsersMigrationExecutor spaceUsersMigrationExecutor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, PluginTransactionTemplate ptx, StepStore stepStore, MigrationLogService migrationLogService) {
        super(prcTask, prcPoller, pollerConfigHandler, migrationLogService);
        this.spaceExportExecutor = spaceExportExecutor;
        this.prcStep = prcStep;
        this.ptx = ptx;
        this.stepStore = stepStore;
        this.spaceUsersMigrationExecutor = spaceUsersMigrationExecutor;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
    }

    @VisibleForTesting
    SpaceExportProcessor(PrcTask<SpaceExportTransferTask> prcTask, SpaceExportExecutor spaceExportExecutor, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler, ScheduledExecutorService heartbeatScheduler, Step prcStep, SpaceUsersMigrationExecutor spaceUsersMigrationExecutor, MigrationDarkFeaturesManager migrationDarkFeaturesManager, PluginTransactionTemplate ptx, StepStore stepStore, MigrationLogService migrationLogService) {
        super(prcTask, prcPoller, pollerConfigHandler, heartbeatScheduler, migrationLogService);
        this.spaceExportExecutor = spaceExportExecutor;
        this.prcStep = prcStep;
        this.spaceUsersMigrationExecutor = spaceUsersMigrationExecutor;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.stepStore = stepStore;
        this.ptx = ptx;
    }

    @Override
    protected Pair<Step, StepResult> process() {
        log.info("Processing V4 space data export. PrcStep id: {}", (Object)this.prcStep.getId());
        this.setProgressStartTime(this.prcStep, StepType.CONFLUENCE_EXPORT);
        StepResult spaceExportResult = this.spaceExportExecutor.runStepV4(this.prcStep.getId(), this.prcTask);
        if (!this.shouldExecuteSpaceUsersMigration(spaceExportResult)) {
            return Pair.of((Object)this.prcStep, (Object)spaceExportResult);
        }
        this.updatePrcStepToSpaceUsersMigration(this.prcStep, spaceExportResult);
        StepResult usersExportResult = this.spaceUsersMigrationExecutor.runStepV4(this.prcStep.getId(), this.prcTask);
        log.info("Finished processing V4 space data export. PrcStep id: {}", (Object)this.prcStep.getId());
        return Pair.of((Object)this.prcStep, (Object)usersExportResult);
    }

    private void updatePrcStepToSpaceUsersMigration(Step prcStep, StepResult spaceExportResult) {
        Optional result = spaceExportResult.getResult() == null ? Optional.empty() : Optional.of(spaceExportResult.getResult());
        prcStep.setType(StepType.SPACE_USERS_MIGRATION.name());
        prcStep.setConfig((String)result.orElseThrow(() -> new IllegalStateException("No result from export step")));
        this.ptx.write(() -> this.stepStore.update(prcStep));
    }

    private boolean shouldExecuteSpaceUsersMigration(StepResult spaceExportResult) {
        if (this.migrationDarkFeaturesManager.isExportOnlyEnabled()) {
            log.info("Export only mode is enabled. Skipping space users migration step");
            return false;
        }
        return spaceExportResult.isSuccess() && !spaceExportResult.isStopped();
    }
}

