/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.udc.utils;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.migration.agent.entity.CloudSite;
import com.atlassian.migration.agent.entity.IncorrectEmail;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.email.DomainId;
import com.atlassian.migration.agent.service.email.EmailsSource;
import com.atlassian.migration.agent.service.impl.MigrationUser;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.correctedemails.CorrectedEmail;
import com.atlassian.migration.udc.common.model.user.User;
import com.atlassian.migration.udc.common.model.user.UserWithId;
import com.atlassian.migration.udc.common.model.userbasescan.UserBaseScan;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class UDCMapperUtils {
    private UDCMapperUtils() {
    }

    public static User toUser(ConfluenceUser confluenceUser, boolean active) {
        return UDCMapperUtils.toNullSafeUser(confluenceUser.getEmail(), confluenceUser.getFullName(), active, confluenceUser.getName(), confluenceUser.getKey().getStringValue());
    }

    public static List<MigrationUser> toMigrationUsers(List<User> users) {
        return users.stream().map(user -> new MigrationUser(user.getUserKey(), user.getUserName(), user.getFullName(), user.getEmail(), user.getActive())).collect(Collectors.toList());
    }

    public static User toUser(MigrationUser migrationUser) {
        return UDCMapperUtils.toNullSafeUser(migrationUser.getEmail(), migrationUser.getFullName(), migrationUser.isActive(), migrationUser.getUsername(), migrationUser.getUserKey());
    }

    public static List<User> toUsers(List<MigrationUser> migrationUsers) {
        return migrationUsers.stream().map(UDCMapperUtils::toUser).collect(Collectors.toList());
    }

    private static User toNullSafeUser(String email, String fullName, boolean active, String username, String userKey) {
        return new User(Objects.toString(email, ""), Objects.toString(fullName, ""), active, Objects.toString(username, ""), userKey);
    }

    public static CheckType toCheckType(EmailCheckType checkType) {
        switch (checkType) {
            case INV: {
                return CheckType.INVALID_EMAILS;
            }
            case DUP: {
                return CheckType.SHARED_EMAILS;
            }
        }
        throw new IllegalArgumentException("Unknown check type: " + checkType);
    }

    public static EmailCheckType toEmailCheckType(CheckType checkType) {
        if (checkType.equals(CheckType.INVALID_EMAILS)) {
            return EmailCheckType.INV;
        }
        if (checkType.equals(CheckType.SHARED_EMAILS)) {
            return EmailCheckType.DUP;
        }
        throw new IllegalArgumentException("Unknown check type: " + checkType);
    }

    public static com.atlassian.migration.udc.common.model.email.EmailsSource toEmailsSource(EmailsSource emailsSource) {
        switch (emailsSource) {
            case FETCHED: {
                return com.atlassian.migration.udc.common.model.email.EmailsSource.FETCHED;
            }
            case PREFETCHED: {
                return com.atlassian.migration.udc.common.model.email.EmailsSource.PREFETCHED;
            }
        }
        throw new IllegalArgumentException("Unknown emails source: " + (Object)((Object)emailsSource));
    }

    public static EmailsSource toEmailsSource(com.atlassian.migration.udc.common.model.email.EmailsSource emailsSource) {
        switch (emailsSource) {
            case FETCHED: {
                return EmailsSource.FETCHED;
            }
            case PREFETCHED: {
                return EmailsSource.PREFETCHED;
            }
        }
        throw new IllegalArgumentException("Unknown emails source: " + emailsSource);
    }

    public static com.atlassian.migration.udc.common.model.incorrectemail.IncorrectEmail toIncorrectEmail(IncorrectEmail it) {
        return new com.atlassian.migration.udc.common.model.incorrectemail.IncorrectEmail(it.getScanId(), it.getUserKey(), UDCMapperUtils.toEmailCheckType(it.getCheckType()), it.getCheckType().value(), it.getUserName(), it.getEmail(), it.getNewEmail(), it.getDirectoryName(), it.getLastAuthenticated());
    }

    public static IncorrectEmail toIncorrectEmail(com.atlassian.migration.udc.common.model.incorrectemail.IncorrectEmail it) {
        return new IncorrectEmail(it.getUserKey(), it.getUserName(), it.getNewEmail(), it.getOldEmail(), UDCMapperUtils.toCheckType(it.getCheckType()), Instant.now(), it.getExecutionId(), it.getDirectoryId(), it.getDirectoryName(), it.getLastAuthenticated());
    }

    public static CorrectedEmail toCorrectedEmail(com.atlassian.migration.agent.entity.CorrectedEmail ce) {
        return new CorrectedEmail(ce.getUserKey(), ce.getUserName(), ce.getType(), ce.getOldEmail(), ce.getNewEmail(), ce.getTombstone().booleanValue(), ce.getAccountType(), ce.getUdcMode(), ce.getDraft().booleanValue(), UUID.fromString(ce.getId()));
    }

    public static com.atlassian.migration.agent.entity.CorrectedEmail toCorrectedEmail(CorrectedEmail ce) {
        return new com.atlassian.migration.agent.entity.CorrectedEmail(ce.getKey(), ce.getUserName(), ce.getType(), ce.getOldEmail(), ce.getNewEmail(), ce.getTombstone(), ce.getAccountType(), ce.getUdcMode(), ce.getDraft());
    }

    public static com.atlassian.migration.udc.common.model.cloud.CloudSite toUDCCloudSite(CloudSite cloudSite) {
        return new com.atlassian.migration.udc.common.model.cloud.CloudSite(cloudSite.getCloudId(), cloudSite.getCloudUrl(), cloudSite.getContainerToken());
    }

    public static CloudSite toCloudSite(com.atlassian.migration.udc.common.model.cloud.CloudSite cloudSite) {
        return new CloudSite(cloudSite.getCloudId(), cloudSite.getCloudUrl(), cloudSite.getContainerToken());
    }

    public static UserWithId toUserWithId(ConfluenceUser confluenceUser, String userKey) {
        return new UserWithId(confluenceUser.getEmail(), confluenceUser.getFullName(), confluenceUser.getName(), userKey, String.valueOf(userKey.hashCode()));
    }

    public static UserBaseScan toUDC(com.atlassian.migration.agent.entity.UserBaseScan scan) {
        return new UserBaseScan(scan.getStatus(), scan.getStarted().toEpochMilli(), scan.getFinished() == null ? 0L : scan.getFinished().toEpochMilli(), scan.getInvalidUsers(), scan.getDuplicateUsers(), 0L, 0L, scan.getId());
    }

    public static com.atlassian.migration.agent.entity.UserBaseScan fromUDC(UserBaseScan scan) {
        com.atlassian.migration.agent.entity.UserBaseScan userBaseScan = new com.atlassian.migration.agent.entity.UserBaseScan(scan.getId(), scan.getStatus(), scan.getInvalidUsersCount(), scan.getDuplicatedUsersCount(), Instant.ofEpochMilli(scan.getStartedAt()));
        if (scan.getFinishedAt() > 0L) {
            userBaseScan.setFinished(Instant.ofEpochMilli(scan.getFinishedAt()));
        }
        return userBaseScan;
    }

    public static DomainId toDomainId(com.atlassian.migration.udc.common.model.email.DomainId it) {
        return new DomainId(it.getDomain());
    }

    public static com.atlassian.migration.udc.common.model.email.DomainId toDomainId(DomainId it) {
        return new com.atlassian.migration.udc.common.model.email.DomainId(it.getStandardizedDomain());
    }
}

