/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails.remote;

import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.config.MigrationAgentConfiguration;
import com.atlassian.migration.agent.okhttp.HttpService;
import com.atlassian.migration.agent.okhttp.OKHttpProxyBuilder;
import com.atlassian.migration.agent.okhttp.RetryPolicyBuilder;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.impl.UserAgentInterceptor;
import com.atlassian.migration.agent.service.version.PluginVersionManager;
import com.atlassian.sal.api.license.LicenseHandler;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class InstanceAssessmentConfigClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceAssessmentConfigClient.class);
    private static final String L1_ASSESSMENTS_PATH = "/l1-assessments";
    private static final String CONFIG_PATH = "/l1-assessments/config";
    private static final String UNKNOWN = "UNKNOWN";
    private final MigrationAgentConfiguration migrationAgentConfiguration;
    private final HttpService httpService;
    private final LicenseHandler licenseHandler;
    private final PluginVersionManager pluginVersionManager;
    private final MigrationDarkFeaturesManager featuresManager;

    public InstanceAssessmentConfigClient(MigrationAgentConfiguration migrationAgentConfiguration, UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder, LicenseHandler licenseHandler, PluginVersionManager pluginVersionManager, MigrationDarkFeaturesManager featuresManager) {
        this(migrationAgentConfiguration, new HttpService(() -> InstanceAssessmentConfigClient.buildHttpClient(userAgentInterceptor, okHttpProxyBuilder)), licenseHandler, pluginVersionManager, featuresManager);
    }

    @VisibleForTesting
    public InstanceAssessmentConfigClient(MigrationAgentConfiguration migrationAgentConfiguration, HttpService httpService, LicenseHandler licenseHandler, PluginVersionManager pluginVersionManager, MigrationDarkFeaturesManager featuresManager) {
        this.httpService = httpService;
        this.migrationAgentConfiguration = migrationAgentConfiguration;
        this.licenseHandler = licenseHandler;
        this.pluginVersionManager = pluginVersionManager;
        this.featuresManager = featuresManager;
    }

    public InstanceAssessmentConfig resolveConfig() {
        return this.resolveConfig(this.getDefaultConfig());
    }

    public InstanceAssessmentConfig resolveConfig(InstanceAssessmentConfig initialConfig) {
        if (this.featuresManager.isAssessmentDynamicConfigEnabled()) {
            try {
                InstanceAssessmentConfig fetchedConfig = this.fetchConfig();
                log.info("Fetched remote assessment config: {}", (Object)fetchedConfig);
                return fetchedConfig;
            }
            catch (Exception ex) {
                log.error("Failed to fetch assessment config from remote, will use default one", (Throwable)ex);
                return initialConfig;
            }
        }
        return initialConfig;
    }

    public InstanceAssessmentConfig getDefaultConfig() {
        return this.featuresManager.isAssessmentDynamicConfigEnabled() ? InstanceAssessmentConfig.quick() : InstanceAssessmentConfig.full();
    }

    private InstanceAssessmentConfig fetchConfig() {
        Request request = new Request.Builder().url(this.getUriBuilder().path(CONFIG_PATH).queryParam("productFamily", new Object[]{"CONFLUENCE"}).queryParam("serverId", new Object[]{Optional.ofNullable(this.licenseHandler.getServerId()).orElse(UNKNOWN)}).queryParam("cmaVersion", new Object[]{this.pluginVersionManager.getPluginVersion()}).toUriString()).addHeader("Accept", "application/json").get().build();
        return this.callJsonWithRetries(request, new TypeReference<InstanceAssessmentConfig>(){});
    }

    private UriComponentsBuilder getUriBuilder() {
        return UriComponentsBuilder.fromHttpUrl((String)this.migrationAgentConfiguration.getPortfolioAnalyzerServiceUrl());
    }

    private <T> T callJsonWithRetries(Request request, TypeReference<T> bodyType) {
        return (T)Failsafe.with(RetryPolicyBuilder.policyForPortfolioAnalyzerConfig(), (Policy[])new RetryPolicy[0]).get(() -> this.httpService.callJson(request, bodyType));
    }

    private static OkHttpClient buildHttpClient(UserAgentInterceptor userAgentInterceptor, OKHttpProxyBuilder okHttpProxyBuilder) {
        return okHttpProxyBuilder.getProxyBuilder().connectTimeout(30L, TimeUnit.SECONDS).followRedirects(true).followSslRedirects(true).readTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)userAgentInterceptor).build();
    }
}

