/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.InfrastructureAssessmentService;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;

public class InstanceMetadataOutputFileGenerator
implements AssessmentOutputFileGenerator {
    private final InfrastructureAssessmentService infrastructureAssessmentService;
    private final OutputPathGenerator outputPathGenerator;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        try {
            InstanceAssessmentResult result = this.infrastructureAssessmentService.fetchData(instanceMetadataDto);
            Path path = this.outputPathGenerator.jsonFilePath(OutputFilenames.INSTANCE_METADATA.getFilename(date));
            SerializationUtil.saveJson(path.toFile(), result);
            return Collections.singleton(path);
        }
        catch (IOException e) {
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    @Generated
    public InstanceMetadataOutputFileGenerator(InfrastructureAssessmentService infrastructureAssessmentService, OutputPathGenerator outputPathGenerator) {
        this.infrastructureAssessmentService = infrastructureAssessmentService;
        this.outputPathGenerator = outputPathGenerator;
    }
}

