/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.entity.GuardrailsResponseGroup;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.store.guardrails.GuardrailsResponseGroupStore;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class AssessmentConfigMetadataOutputFileGenerator
implements AssessmentOutputFileGenerator {
    private final OutputPathGenerator outputPathGenerator;
    private final GuardrailsResponseGroupStore guardrailsResponseGroupStore;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        String config = example ? this.example() : this.actualConfig();
        return this.createPath(date, config);
    }

    @NotNull
    private Set<Path> createPath(String date, String configJson) {
        if (configJson == null || configJson.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            Path path = this.outputPathGenerator.jsonFilePath(OutputFilenames.CONFIG_METADATA.getFilename(date));
            FileUtils.writeStringToFile((File)path.toFile(), (String)configJson, (Charset)StandardCharsets.UTF_8);
            return Collections.singleton(path);
        }
        catch (IOException e) {
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    private String actualConfig() {
        return this.guardrailsResponseGroupStore.findLast().map(GuardrailsResponseGroup::getConfigJson).orElse(null);
    }

    private String example() {
        return Jsons.valueAsString(InstanceAssessmentConfig.full());
    }

    @Generated
    public AssessmentConfigMetadataOutputFileGenerator(OutputPathGenerator outputPathGenerator, GuardrailsResponseGroupStore guardrailsResponseGroupStore) {
        this.outputPathGenerator = outputPathGenerator;
        this.guardrailsResponseGroupStore = guardrailsResponseGroupStore;
    }
}

