/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.migration.agent.service.check.UnableToWriteCsvException;
import com.atlassian.migration.agent.service.check.csv.AbstractCheckResultCSVBean;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import com.atlassian.migration.agent.service.util.CsvWriterFacade;
import com.atlassian.migration.agent.service.util.PreferenceType;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class CheckResultCSVWriter {
    private static final String UNABLE_TO_UPLOAD_EXCEPTION_MESSAGE = "Unable to write beans to csv.";

    public <T extends AbstractCheckResultCSVBean> void writeResultsInStream(OutputStream outputStream, CheckResultCSVContainer<T> container) {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            CsvWriterFacade csvWriterFacade = new CsvWriterFacade(writer, PreferenceType.STANDARD);
            csvWriterFacade.write(container.headers(), false);
            for (AbstractCheckResultCSVBean bean : container.beans()) {
                ArrayList<String> fields = new ArrayList<String>();
                for (String mapping : container.fieldMappings()) {
                    fields.add(BeanUtils.getProperty((Object)bean, (String)mapping));
                }
                csvWriterFacade.write(fields.toArray(new String[0]), false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(UNABLE_TO_UPLOAD_EXCEPTION_MESSAGE, e);
        }
    }

    public void writeListResultsInStream(OutputStream outputStream, String[] headers, Collection<List<String>> beans) {
        if (headers == null || beans == null || beans.isEmpty()) {
            throw new UnableToWriteCsvException(UNABLE_TO_UPLOAD_EXCEPTION_MESSAGE, new Throwable("Null headers or beans."));
        }
        try {
            CsvWriterFacade csvWriterFacade = new CsvWriterFacade(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), PreferenceType.STANDARD);
            csvWriterFacade.write(headers, false);
            for (List<String> bean : beans) {
                csvWriterFacade.write(bean.toArray(new String[0]), false);
            }
        }
        catch (Exception e) {
            throw new UnableToWriteCsvException(UNABLE_TO_UPLOAD_EXCEPTION_MESSAGE, e);
        }
    }
}

