/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckContext;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CheckRegistry {
    private final Map<CheckType, CheckRegistration<CheckContext>> checksByCheckType;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public CheckRegistry(List<CheckRegistration> checkRegistrations, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder) {
        this.checksByCheckType = checkRegistrations.stream().collect(Collectors.toMap(CheckRegistration::getCheckType, reg -> reg));
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }

    public CheckContextProvider<CheckContext> getCheckContextProvider(CheckType checkType) {
        return this.checksByCheckType.get(checkType).getCheckContextProvider();
    }

    public Checker<CheckContext> getChecker(CheckType checkType) {
        return this.checksByCheckType.get(checkType).getChecker();
    }

    public CheckResultMapper getResultMapper(CheckType checkType) {
        return this.checksByCheckType.get(checkType).getCheckResultMapper();
    }

    public boolean shouldBlockMigration(CheckStatus checkStatus) {
        CheckType checkType = CheckType.fromString(checkStatus.checkType);
        return checkType.blocksMigration();
    }

    EventDto getAnalyticsEventModel(CheckType checkType, CheckResult checkResult, String executionId, long totalTime, @Nullable UUID uniqueId) {
        EventDto analyticsEventModel;
        Integer errorCode = Checker.retrieveExecutionErrorCode((CheckResult)checkResult);
        if (errorCode != null) {
            String actionSubject = this.checksByCheckType.get(checkType).getFailedToExecuteAnalyticsEventName();
            analyticsEventModel = this.preflightChecksAnalyticsEventBuilder.buildPreflightFailed(actionSubject, executionId, errorCode, uniqueId);
        } else {
            analyticsEventModel = this.checksByCheckType.get(checkType).getAnalyticsEventModel(checkResult, totalTime);
        }
        return analyticsEventModel;
    }
}

