/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.migration.agent.service.BaseLogContext;
import java.util.Map;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class BaseLogger<T extends BaseLogContext> {
    public void logInfo(Logger logger, T context, String message) {
        this.log(context, logger, Level.INFO, message, null);
    }

    public void logError(Logger logger, T context, String message, Throwable throwable) {
        this.log(context, logger, Level.ERROR, message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void log(T context, Logger logger, Level level, String message, Throwable throwable) {
        Map<String, Object> logCtx = ((BaseLogContext)context).getLogContext();
        try {
            for (Map.Entry<String, Object> entry : logCtx.entrySet()) {
                if (entry.getValue() == null) continue;
                MDC.put((String)entry.getKey(), (String)entry.getValue().toString());
            }
            switch (level.toInt()) {
                case 7: {
                    logger.debug(message);
                    return;
                }
                case 4: {
                    if (throwable != null) {
                        logger.warn(message, throwable);
                        return;
                    } else {
                        logger.warn(message);
                        return;
                    }
                }
                case 3: {
                    if (throwable != null) {
                        logger.error(message, throwable);
                        return;
                    } else {
                        logger.error(message);
                        return;
                    }
                }
                default: {
                    logger.info(message);
                    return;
                }
            }
        }
        finally {
            MDC.clear();
        }
    }
}

