/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.guardrails;

import com.atlassian.migration.agent.dto.InstanceMetadataDto;
import com.atlassian.migration.agent.service.guardrails.AssessmentOutputFileGenerator;
import com.atlassian.migration.agent.service.guardrails.InstanceAssessmentConfig;
import com.atlassian.migration.agent.service.guardrails.OutputFileGeneratorException;
import com.atlassian.migration.agent.service.guardrails.OutputFilenames;
import com.atlassian.migration.agent.service.guardrails.OutputPathGenerator;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentResult;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentService;
import com.atlassian.migration.agent.service.guardrails.macro.MacroAssessmentStore;
import com.atlassian.migration.agent.service.guardrails.util.SerializationUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;

public class MacroAssessmentOutputFileGenerator
implements AssessmentOutputFileGenerator {
    private final MacroAssessmentService macroAssessmentService;
    private final MacroAssessmentStore macroAssessmentStore;
    private final OutputPathGenerator outputPathGenerator;

    @Override
    public Set<Path> generate(LocalDate today, String date, InstanceMetadataDto instanceMetadataDto, boolean example) throws OutputFileGeneratorException {
        try {
            MacroAssessmentResult result;
            MacroAssessmentResult macroAssessmentResult = result = example ? this.macroAssessmentService.example() : this.macroAssessmentStore.getMacroAssessmentResult(today);
            if (result == null) {
                return Collections.emptySet();
            }
            result.addIdentification(instanceMetadataDto.getServerId(), instanceMetadataDto.getAssessmentDate());
            Path outputPath = this.outputPathGenerator.jsonFilePath(OutputFilenames.MACROS.getFilename(date));
            SerializationUtil.saveJson(outputPath.toFile(), result);
            return Collections.singleton(outputPath);
        }
        catch (IOException e) {
            throw new OutputFileGeneratorException(e.getMessage());
        }
    }

    @Override
    public Boolean shouldInclude(InstanceAssessmentConfig config) {
        return config.isExecuteMacroAssessment();
    }

    @Generated
    public MacroAssessmentOutputFileGenerator(MacroAssessmentService macroAssessmentService, MacroAssessmentStore macroAssessmentStore, OutputPathGenerator outputPathGenerator) {
        this.macroAssessmentService = macroAssessmentService;
        this.macroAssessmentStore = macroAssessmentStore;
        this.outputPathGenerator = outputPathGenerator;
    }
}

