/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check.app.listener;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckContextProvider;
import com.atlassian.migration.agent.service.check.CheckRegistration;
import com.atlassian.migration.agent.service.check.CheckType;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerChecker;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerContext;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerContextProvider;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerDto;
import com.atlassian.migration.agent.service.check.app.listener.AppListenerMapper;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.util.UriComponentsBuilder;

@ParametersAreNonnullByDefault
public class AppListenerCheckRegistration
implements CheckRegistration<AppListenerContext> {
    private static final String UPM_PATH = "/plugins/servlet/upm";
    private final AppListenerChecker checker;
    private final AppListenerContextProvider appListenerContextProvider;
    private final AppListenerMapper appListenerMapper;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;

    public AppListenerCheckRegistration(AppListenerChecker checker, AppListenerContextProvider appListenerContextProvider, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder, SystemInformationService sysInfoService) {
        this.checker = checker;
        this.appListenerContextProvider = appListenerContextProvider;
        this.appListenerMapper = new AppListenerMapper(UriComponentsBuilder.fromHttpUrl((String)sysInfoService.getConfluenceInfo().getBaseUrl()).path(UPM_PATH).toUriString());
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
    }

    @Override
    public CheckType getCheckType() {
        return CheckType.APP_MISSING_LISTENER_CHECK;
    }

    @Override
    public Checker<AppListenerContext> getChecker() {
        return this.checker;
    }

    @Override
    public CheckContextProvider<AppListenerContext> getCheckContextProvider() {
        return this.appListenerContextProvider;
    }

    @Override
    public CheckResultMapper getCheckResultMapper() {
        return this.appListenerMapper;
    }

    @Override
    public EventDto getAnalyticsEventModel(CheckResult checkResult, long totalTime) {
        Set<String> appsMissingListener = AppListenerChecker.retrieveAppsMissingListeners(checkResult.details).stream().map(AppListenerDto::getKey).collect(Collectors.toSet());
        Set<String> appsWithListener = AppListenerChecker.retrieveAppsWithListeners(checkResult.details);
        return this.preflightChecksAnalyticsEventBuilder.buildPreflightAppListenerCheck(checkResult.success, appsWithListener, appsMissingListener, totalTime);
    }

    @Override
    public String getFailedToExecuteAnalyticsEventName() {
        return "appMissingListenerCheck";
    }
}

