/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.worker;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.migration.agent.entity.ConfluenceSpaceTask;
import com.atlassian.migration.agent.entity.Step;
import com.atlassian.migration.agent.entity.Task;
import com.atlassian.migration.agent.service.impl.StepType;
import com.atlassian.migration.agent.service.log.MigrationLogService;
import com.atlassian.migration.agent.service.prc.PollerConfigHandler;
import com.atlassian.migration.agent.service.stepexecutor.space.SpaceUploadExecutor;
import com.atlassian.migration.agent.store.PlanStore;
import com.atlassian.migration.agent.store.StepStore;
import com.atlassian.migration.agent.store.TaskStore;
import com.atlassian.migration.agent.store.tx.PluginTransactionTemplate;
import com.atlassian.migration.agent.v4.ProgressUnit;
import com.atlassian.migration.agent.v4.migration.prc.PrcTask;
import com.atlassian.migration.agent.v4.processors.SpaceUploadProcessor;
import com.atlassian.migration.agent.v4.tasks.SpaceUploadTransferTask;
import com.atlassian.migration.agent.v4.tasks.TransferTaskType;
import com.atlassian.migration.agent.v4.worker.V4Worker;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.CommandName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class SpaceUploadWorker
extends V4Worker<SpaceUploadTransferTask> {
    @Autowired
    private final SpaceUploadExecutor spaceUploadExecutor;
    @Autowired
    private final SpaceManager spaceManager;

    public SpaceUploadWorker(List<ProgressUnit> supportedUnits, SpaceUploadExecutor spaceUploadExecutor, PlanStore planStore, StepStore stepStore, PluginTransactionTemplate defaultPluginTransactionTemplate, TaskStore taskStore, SpaceManager spaceManager, MigrationLogService migrationLogService) {
        super(supportedUnits, planStore, taskStore, stepStore, defaultPluginTransactionTemplate, migrationLogService);
        this.spaceUploadExecutor = spaceUploadExecutor;
        this.spaceManager = spaceManager;
        this.commandName = CommandName.CONFLUENCE_SPACE_UPLOAD;
    }

    @Override
    public void process(PrcTask<SpaceUploadTransferTask> prcTask, OnDemandPrcPoller prcPoller, PollerConfigHandler pollerConfigHandler) {
        Step prcStep = this.translatePrcTaskAsStep(prcTask);
        prcStep.setType(StepType.DATA_UPLOAD.name());
        this.processPayloadAndSetConfig(prcTask.getCommand().getPayload(), prcStep);
        this.getPtx().write(() -> this.getStepStore().update(prcStep));
        SpaceUploadProcessor processor = new SpaceUploadProcessor(prcTask, prcStep, prcPoller, pollerConfigHandler, this.spaceUploadExecutor, this.migrationLogService);
        processor.initiate();
    }

    private void processPayloadAndSetConfig(String payload, Step prcStep) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode payloadJson = mapper.readTree(payload);
            String exportFileId = payloadJson.get("exportFileId").asText();
            prcStep.setConfig(exportFileId);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse payload", e);
        }
    }

    @Override
    public Task getMigTask(List<Task> tasks, PrcTask<SpaceUploadTransferTask> prcTask) {
        String spaceKey = Objects.requireNonNull(this.spaceManager.getSpace(Long.parseLong(prcTask.getTransferTask().getSpaceId()))).getKey();
        return tasks.stream().filter(ConfluenceSpaceTask.class::isInstance).map(ConfluenceSpaceTask.class::cast).filter(task1 -> spaceKey.equals(task1.getSpaceKey())).findFirst().orElse(null);
    }

    @Override
    public void setStepConfig(Step step) {
        ConfluenceSpaceTask task = (ConfluenceSpaceTask)step.getTask();
        step.setConfig(task.getSpaceKey());
    }

    @Override
    public TransferTaskType getTransferTaskType() {
        return TransferTaskType.CONFLUENCE_SPACE_UPLOAD;
    }
}

