/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.v4.migration;

import com.atlassian.migration.agent.service.util.StopConditionCheckingUtil;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    private ThreadUtils() {
    }

    public static void safeExecutePeriodicallyUntilStopped(Callable<Boolean> what, Duration delay, Supplier<Boolean> shouldKeepRunning) {
        while (shouldKeepRunning.get().booleanValue() && !Thread.currentThread().isInterrupted()) {
            try {
                what.call();
            }
            catch (Throwable e) {
                if (StopConditionCheckingUtil.isStoppingExceptionInCausalChain(e)) {
                    Thread.currentThread().interrupt();
                }
                log.error("Uncaught exception in periodic executor", e);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(delay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

