/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.store.guardrails.queries;

import com.atlassian.migration.agent.CommonBeanConfiguration;
import com.atlassian.migration.agent.store.guardrails.QueryIds;
import com.atlassian.migration.agent.store.guardrails.queries.TupleQuery;
import com.atlassian.migration.agent.store.jpa.EntityManagerTemplate;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Import(value={CommonBeanConfiguration.class})
@Configuration
public class GuardrailsTupleQueriesConfiguration {
    private static final String PAGE_ID = "page_id";
    private static final String SPACE_ID = "space_id";
    @Autowired
    EntityManagerTemplate tmpl;

    @Bean
    public TupleQuery maxLikeInPageQuery() {
        return this.create(QueryIds.MAX_LIKE_IN_PAGE, "select contentId as page_id, count(id) as like_count from Likes where contentId in (select c.id from Content c where c.type in ('PAGE', 'BLOGPOST') and c.status = 'current' and c.previousVersion is null) group by contentId order by 2 desc", (Map<String, Object>)ImmutableMap.of((Object)PAGE_ID, (Object)840174, (Object)"like_count", (Object)278));
    }

    @Bean
    public TupleQuery maxNumberOfSpaceGroupPermissionsInASpaceQuery() {
        return this.create(QueryIds.MAX_SPACE_GROUP_PERMISSION_IN_SPACE, "select sp.space.id as space_id, count(sp.id) as permission_count from SpacePermission as sp where sp.permGroupName is not null group by sp.space.id order by permission_count desc", (Map<String, Object>)ImmutableMap.of((Object)SPACE_ID, (Object)195133673L, (Object)"permission_count", (Object)82L));
    }

    @Bean
    public TupleQuery maxNumberOfSpacePermissionsInASpaceQuery() {
        return this.create(QueryIds.MAX_SPACE_PERMISSION_IN_SPACE, "select sp.space.id as space_id, count(sp.id) as space_permission_count from SpacePermission as sp group by sp.space order by 2 desc", (Map<String, Object>)ImmutableMap.of((Object)SPACE_ID, (Object)195133673L, (Object)"space_permission_count", (Object)207L));
    }

    @Bean
    public TupleQuery maxPageWidthQuery() {
        return this.create(QueryIds.MAX_PAGE_WIDTH, "select parentId as page_id, count(*) as children_count from Content where parentId is not null and type='PAGE' and status='current' group by parentId order by 2 desc", (Map<String, Object>)ImmutableMap.of((Object)PAGE_ID, (Object)49142599L, (Object)"children_count", (Object)300));
    }

    @Bean
    public TupleQuery maxRestrictionsInPageQuery() {
        return this.create(QueryIds.MAX_RESTRICTIONS_IN_PAGE, "select cps.contentId as page_id, count(cp.id) as restriction_count from ContentPerm cp, ContentPermSet cps, Content c where cps.id = cp.cpsId and cps.contentId = c.id and c.status in ('current', 'draft') group by cps.contentId order by restriction_count desc", (Map<String, Object>)ImmutableMap.of((Object)PAGE_ID, (Object)34816016L, (Object)"restriction_count", (Object)44L));
    }

    @Bean
    public TupleQuery maxSpaceUserPermissionQuery() {
        return this.create(QueryIds.MAX_SPACE_USER_PERMISSION, "select space.id as space_id, count(id) as space_permission_count from SpacePermission where permUsername is not null group by space.id order by 2 desc", (Map<String, Object>)ImmutableMap.of((Object)SPACE_ID, (Object)115417266L, (Object)"space_permission_count", (Object)175L));
    }

    private TupleQuery create(QueryIds queryId, String query, Map<String, Object> exampleResult) {
        return new TupleQuery(queryId, this.tmpl, query, exampleResult);
    }
}

