/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.agent.service.check;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.migration.MigrationDarkFeaturesManager;
import com.atlassian.migration.agent.json.Jsons;
import com.atlassian.migration.agent.logging.ContextLoggerFactory;
import com.atlassian.migration.agent.service.analytics.AnalyticsEventService;
import com.atlassian.migration.agent.service.analytics.builders.PreflightChecksAnalyticsEventBuilder;
import com.atlassian.migration.agent.service.check.CheckResultCSVWriter;
import com.atlassian.migration.agent.service.check.SafeObjectInputStream;
import com.atlassian.migration.agent.service.check.csv.AbstractCheckResultCSVBean;
import com.atlassian.migration.agent.service.check.csv.AppVendorCheckCSVContainer;
import com.atlassian.migration.agent.service.check.csv.CheckResultCSVContainer;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class CheckResultFileManager {
    private static final Logger log = ContextLoggerFactory.getLogger(CheckResultFileManager.class);
    public static final String CAN_T_WRITE_OBJECT_TO_FILE = "Can't write object to file";
    private final BootstrapManager bootstrapManager;
    private final MigrationDarkFeaturesManager migrationDarkFeaturesManager;
    private final PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder;
    private final AnalyticsEventService analyticsEventService;

    public CheckResultFileManager(BootstrapManager bootstrapManager, MigrationDarkFeaturesManager migrationDarkFeaturesManager, PreflightChecksAnalyticsEventBuilder preflightChecksAnalyticsEventBuilder, AnalyticsEventService analyticsEventService) {
        this.bootstrapManager = bootstrapManager;
        this.migrationDarkFeaturesManager = migrationDarkFeaturesManager;
        this.preflightChecksAnalyticsEventBuilder = preflightChecksAnalyticsEventBuilder;
        this.analyticsEventService = analyticsEventService;
    }

    public void saveToFile(String fileName, CheckResult checkResult) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.getPreflightCheckFile(fileName).toFile());
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);){
            objectOutputStream.writeObject(checkResult);
        }
        catch (IOException e) {
            throw new RuntimeException(CAN_T_WRITE_OBJECT_TO_FILE, e);
        }
    }

    public <T extends AbstractCheckResultCSVBean> File saveToFileInCSVFormat(String fileName, CheckResultCSVContainer<T> checkResultCSVContainer) {
        File file;
        File file2 = this.getPreflightCheckFile(fileName).toFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            CheckResultCSVWriter checkResultCSVWriter = new CheckResultCSVWriter();
            checkResultCSVWriter.writeResultsInStream(fileOutputStream, checkResultCSVContainer);
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error(CAN_T_WRITE_OBJECT_TO_FILE, (Throwable)e);
                throw new RuntimeException(CAN_T_WRITE_OBJECT_TO_FILE, e);
            }
        }
        fileOutputStream.close();
        return file;
    }

    public <T extends AbstractCheckResultCSVBean> File saveToFileInCSVFormat(String fileName, AppVendorCheckCSVContainer appVendorCheckCSVContainer) {
        File file;
        File file2 = this.getPreflightCheckFile(fileName).toFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            CheckResultCSVWriter checkResultCSVWriter = new CheckResultCSVWriter();
            checkResultCSVWriter.writeListResultsInStream(fileOutputStream, appVendorCheckCSVContainer.headers(), appVendorCheckCSVContainer.beans());
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error(CAN_T_WRITE_OBJECT_TO_FILE, (Throwable)e);
                throw new RuntimeException(CAN_T_WRITE_OBJECT_TO_FILE, e);
            }
        }
        fileOutputStream.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckResult readFromFile(String file) {
        try {
            if (this.migrationDarkFeaturesManager.disableSafeDeserialization()) {
                CheckResult checkResult = this.readFromFileWithoutSafeDeserialization(file);
                return checkResult;
            }
            CheckResult checkResult = this.readFromFileWithSafeDeserialization(file);
            return checkResult;
        }
        finally {
            try {
                this.readFromFileWithSafeDeserialization(file);
            }
            catch (Throwable e) {
                log.error("Failed to read object from file", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public CheckResult readFromFileWithoutSafeDeserialization(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public CheckResult readFromFileWithSafeDeserialization(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CheckResult readObjectFromStream(SafeObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            CheckResult checkResult = (CheckResult)objectInputStream.readObject();
            return checkResult;
        }
        catch (Throwable e) {
            String errorReason = e.getCause() == null ? String.valueOf(e) : String.valueOf(e.getCause());
            this.analyticsEventService.saveAnalyticsEventAsync(() -> this.preflightChecksAnalyticsEventBuilder.buildCheckResultDeserializationErrorEvent(errorReason));
            throw new InvalidClassException("Unauthorized deserialization attempt", e.getClass().getName());
        }
    }

    public <T> String writeToJsonFile(String prefix, List<T> records) throws IOException {
        File file = this.getPreflightCheckFile(prefix + "-" + UUID.randomUUID()).toFile();
        Jsons.valueAsJsonFile(file, records);
        log.info("Saved  records to file: {}", (Object)file.getPath());
        log.debug("Records: {} ", records);
        return file.getPath();
    }

    public <T> List<T> readFromJsonFile(String path, TypeReference<List<T>> typeReference) throws IOException {
        File file = new File(path);
        return (List)Jsons.readValue(file, typeReference);
    }

    public void deleteFile(String file) {
        try {
            Files.delete(this.getPreflightCheckFile(file));
        }
        catch (IOException e) {
            log.error("Failed to clean up file. Reason: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Path getPreflightCheckFile(String file) {
        return this.getPreflightCheckPath().resolve(file);
    }

    private Path getPreflightCheckPath() {
        Path path = Paths.get(this.bootstrapManager.getSharedHome().getAbsolutePath(), "migration", "check");
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                new RuntimeException("Unable to create check directory", e);
            }
        }
        return path;
    }
}

